<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title><?php _e( 'Geotargeting Pro Shortcodes', 'geot' ); ?>:</title>
	<meta name="viewport"
	      content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="stylesheet"
	      href="<?php echo plugin_dir_url( GEOTROOT_PLUGIN_FILE ) . 'includes/geot/Setting/css/geotarget.css'; ?>"/>
	<style type="text/css">
		.button.updated-message, a {
			transition-property: border, background, color;
			transition-duration: .05s;
			transition-timing-function: ease-in-out
		}

		#ajax-loading, .ajax-feedback, .ajax-loading, .imgedit-wait-spin, .list-ajax-loading, .spinner, .wp-header-end {
			visibility: hidden
		}

		.filter-group, .postbox-container .meta-box-sortables, .wp-filter, html.wp-toolbar {
			box-sizing: border-box
		}

		#docs-list, #plugin-information .section, #template textarea, .code, .ltr, code {
			direction: ltr
		}

		#wpwrap {
			height: auto;
			min-height: 100%;
			width: 100%;
			position: relative;
			-webkit-font-smoothing: subpixel-antialiased
		}

		#wpcontent {
			height: 100%;
			padding-left: 20px
		}

		#wpcontent, #wpfooter {
			margin-left: 160px
		}

		.folded #wpcontent, .folded #wpfooter {
			margin-left: 36px
		}

		#wpbody-content {
			padding-bottom: 65px;
			float: left;
			width: 100%;
			overflow: visible !important
		}

		.inner-sidebar {
			float: right;
			clear: right;
			display: none;
			width: 281px;
			position: relative
		}

		.columns-2 .inner-sidebar {
			margin-right: auto;
			width: 286px;
			display: block
		}

		.columns-2 .inner-sidebar #side-sortables, .inner-sidebar #side-sortables {
			min-height: 300px;
			width: 280px;
			padding: 0
		}

		.has-right-sidebar .inner-sidebar {
			display: block
		}

		.has-right-sidebar #post-body {
			float: left;
			clear: left;
			width: 100%;
			margin-right: -2000px
		}

		.has-right-sidebar #post-body-content {
			margin-right: 300px;
			float: none;
			width: auto
		}

		#col-left {
			float: left;
			width: 35%
		}

		#col-right {
			float: right;
			width: 65%
		}

		#col-left .col-wrap {
			padding: 0 6px 0 0
		}

		#col-right .col-wrap {
			padding: 0 0 0 6px
		}

		.alignleft {
			float: left
		}

		.alignright {
			float: right
		}

		#publishing-action .spinner, #save-post, .subsubsub {
			float: left
		}

		.textleft {
			text-align: left
		}

		.textright {
			text-align: right
		}

		.clear {
			clear: both
		}

		.wp-clearfix:after {
			content: "";
			display: table;
			clear: both
		}

		.screen-reader-text, .screen-reader-text span, .ui-helper-hidden-accessible {
			border: 0;
			clip: rect(1px, 1px, 1px, 1px);
			-webkit-clip-path: inset(50%);
			clip-path: inset(50%);
			height: 1px;
			margin: -1px;
			overflow: hidden;
			padding: 0;
			position: absolute;
			width: 1px;
			word-wrap: normal !important
		}

		#templateside, .misc-pub-filename, .pre, .widefat * {
			word-wrap: break-word
		}

		.screen-reader-shortcut {
			position: absolute;
			top: -1000em
		}

		.screen-reader-shortcut:focus {
			left: 6px;
			top: -25px;
			height: auto;
			width: auto;
			display: block;
			font-size: 14px;
			font-weight: 600;
			padding: 15px 23px 14px;
			background: #f1f1f1;
			color: #0073aa;
			z-index: 100000;
			line-height: normal;
			box-shadow: 0 0 2px 2px rgba(0, 0, 0, .6);
			text-decoration: none;
			outline: 0
		}

		.hidden, .js .closed .inside, .js .hide-if-js, .js .wp-core-ui .hide-if-js, .js.wp-core-ui .hide-if-js, .no-js .hide-if-no-js, .no-js .wp-core-ui .hide-if-no-js, .no-js.wp-core-ui .hide-if-no-js {
			display: none
		}

		#menu-management .menu-edit, #menu-settings-column .accordion-container, .comment-ays, .feature-filter, .imgedit-group, .manage-menus, .menu-item-handle, .popular-tags, .stuffbox, .widget-inside, .widget-top, .widgets-holder-wrap, .wp-editor-container, p.popular-tags, table.widefat {
			border: 1px solid #e5e5e5;
			box-shadow: 0 1px 1px rgba(0, 0, 0, .04)
		}

		.comment-ays, .feature-filter, .imgedit-group, .popular-tags, .stuffbox, .widgets-holder-wrap, .wp-editor-container, p.popular-tags, table.widefat {
			background: #fff
		}

		body, html {
			height: 100%;
			margin: 0;
			padding: 0
		}

		body {
			background: #f1f1f1;
			color: #444;
			font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
			font-size: 13px;
			line-height: 1.4em;
			min-width: 600px
		}

		body.iframe {
			min-width: 0;
			padding-top: 1px
		}

		body.modal-open {
			overflow: hidden
		}

		body.mobile.modal-open #wpwrap {
			overflow: hidden;
			position: fixed;
			height: 100%
		}

		iframe, img {
			border: 0
		}

		td {
			font-family: inherit;
			font-size: inherit;
			font-weight: inherit;
			line-height: inherit
		}

		a {
			color: #0073aa
		}

		a, div {
			outline: 0
		}

		a:active, a:hover {
			color: #00a0d2
		}

		.wp-person a:focus .gravatar, a:focus, a:focus .media-icon img {
			color: #124964;
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		h1, h2, h3 {
			color: #23282d
		}

		.ie8 a:focus {
			outline: #5b9dd9 solid 1px
		}

		#adminmenu a:focus, .screen-reader-text:focus {
			box-shadow: none;
			outline: 0
		}

		blockquote, q {
			quotes: none
		}

		blockquote:after, blockquote:before, q:after, q:before {
			content: "";
			content: none
		}

		p {
			font-size: 13px;
			line-height: 1.5;
			margin: 1em 0
		}

		blockquote {
			margin: 1em
		}

		dd, li {
			margin-bottom: 6px
		}

		h1, h2, h3, h4, h5, h6 {
			display: block;
			font-weight: 600
		}

		h1 {
			font-size: 2em;
			margin: .67em 0
		}

		h2, h3 {
			font-size: 1.3em;
			margin: 1em 0
		}

		.update-core-php h2 {
			margin-top: 2em
		}

		.update-messages h2, .update-php h2, h4 {
			font-size: 1em;
			margin: 1.33em 0
		}

		h5 {
			font-size: .83em;
			margin: 1.67em 0
		}

		h6 {
			font-size: .67em;
			margin: 2.33em 0
		}

		ol, ul {
			padding: 0
		}

		ul {
			list-style: none
		}

		ol {
			list-style-type: decimal;
			margin-left: 2em
		}

		ul.ul-disc {
			list-style: disc
		}

		ul.ul-square {
			list-style: square
		}

		ol.ol-decimal {
			list-style: decimal
		}

		ol.ol-decimal, ul.ul-disc, ul.ul-square {
			margin-left: 1.8em
		}

		ol.ol-decimal > li, ul.ul-disc > li, ul.ul-square > li {
			margin: 0 0 .5em
		}

		.code, code {
			font-family: Consolas, Monaco, monospace;
			unicode-bidi: embed
		}

		code, kbd {
			padding: 3px 5px 2px;
			margin: 0 1px;
			background: #eaeaea;
			background: rgba(0, 0, 0, .07);
			font-size: 13px
		}

		.subsubsub {
			list-style: none;
			margin: 8px 0 0;
			padding: 0;
			font-size: 13px;
			color: #666
		}

		.subsubsub a {
			line-height: 2;
			padding: .2em;
			text-decoration: none
		}

		.subsubsub a .count, .subsubsub a.current .count {
			color: #555d66;
			font-weight: 400
		}

		.subsubsub a.current {
			font-weight: 600;
			border: none
		}

		.subsubsub li {
			display: inline-block;
			margin: 0;
			padding: 0;
			white-space: nowrap
		}

		.widefat {
			border-spacing: 0;
			width: 100%;
			clear: both;
			margin: 0
		}

		.widefat a, .widefat button.button-link {
			text-decoration: none
		}

		.widefat td, .widefat th {
			padding: 8px 10px
		}

		.widefat thead td, .widefat thead th {
			border-bottom: 1px solid #e1e1e1
		}

		.widefat tfoot td, .widefat tfoot th {
			border-top: 1px solid #e1e1e1;
			border-bottom: none
		}

		.widefat .no-items td {
			border-bottom-width: 0
		}

		.widefat td {
			vertical-align: top
		}

		.widefat td, .widefat td ol, .widefat td p, .widefat td ul {
			font-size: 13px;
			line-height: 1.5em
		}

		.widefat tfoot td, .widefat th, .widefat thead td {
			text-align: left;
			line-height: 1.3em;
			font-size: 14px
		}

		.updates-table td input, .widefat tfoot td input, .widefat th input, .widefat thead td input {
			margin: 0 0 0 8px;
			padding: 0;
			vertical-align: text-top
		}

		.widefat .check-column {
			width: 2.2em;
			padding: 6px 0 25px;
			vertical-align: top
		}

		.updates-table tbody td.check-column, .widefat tbody th.check-column, .widefat tfoot td.check-column, .widefat thead td.check-column {
			padding: 11px 0 0 3px
		}

		.widefat tfoot td.check-column, .widefat thead td.check-column {
			padding-top: 4px;
			vertical-align: middle
		}

		.update-php div.error, .update-php div.updated {
			margin-left: 0
		}

		.no-js .widefat tfoot .check-column input, .no-js .widefat thead .check-column input {
			display: none
		}

		.column-comments, .column-links, .column-posts, .widefat .num {
			text-align: center
		}

		.widefat th#comments {
			vertical-align: middle
		}

		.wrap {
			margin: 10px 20px 0 2px
		}

		.postbox .inside h2, .wrap [class$=icon32] + h2, .wrap h1, .wrap > h2:first-child {
			font-size: 23px;
			font-weight: 400;
			margin: 0;
			padding: 9px 0 4px;
			line-height: 29px
		}

		.wrap h1.wp-heading-inline {
			display: inline-block;
			margin-right: 5px
		}

		.wp-header-end {
			margin: -2px 0 0
		}

		.subtitle {
			margin: 0;
			padding-left: 25px;
			color: #555d66;
			font-size: 14px;
			font-weight: 400;
			line-height: 1
		}

		.wrap .add-new-h2, .wrap .add-new-h2:active, .wrap .page-title-action, .wrap .page-title-action:active {
			margin-left: 4px;
			padding: 4px 8px;
			position: relative;
			top: -3px;
			text-decoration: none;
			border: none;
			border: 1px solid #ccc;
			border-radius: 2px;
			background: #f7f7f7;
			text-shadow: none;
			font-weight: 600;
			font-size: 13px;
			line-height: normal;
			color: #0073aa;
			cursor: pointer;
			outline: 0
		}

		.wrap .wp-heading-inline + .page-title-action {
			margin-left: 0
		}

		.wrap .add-new-h2:hover, .wrap .page-title-action:hover {
			border-color: #008EC2;
			background: #00a0d2;
			color: #fff
		}

		.page-title-action:focus {
			color: #124964
		}

		.ac_match, .highlight, .subsubsub a.current {
			color: #000
		}

		.wrap .page-title-action:focus {
			border-color: #5b9dd9;
			box-shadow: 0 0 2px rgba(30, 140, 190, .8)
		}

		.wrap h1.long-header {
			padding-right: 0
		}

		.wp-dialog {
			background-color: #fff
		}

		#available-widgets .widget-top:hover, #widgets-left .widget-in-question .widget-top, #widgets-left .widget-top:hover, .widgets-chooser ul, div#widgets-right .widget-top:hover {
			border-color: #999;
			box-shadow: 0 1px 2px rgba(0, 0, 0, .1)
		}

		.sorthelper {
			background-color: #ccf3fa
		}

		.alternate, .striped > tbody > :nth-child(odd), ul.striped > :nth-child(odd) {
			background-color: #f9f9f9
		}

		.bar {
			background-color: #e8e8e8;
			border-right-color: #99d
		}

		.highlight {
			background-color: #e4f2fd
		}

		.wp-ui-primary {
			color: #fff;
			background-color: #32373c
		}

		.wp-ui-text-primary {
			color: #32373c
		}

		.wp-ui-highlight {
			color: #fff;
			background-color: #1e8cbe
		}

		.wp-ui-text-highlight {
			color: #1e8cbe
		}

		.wp-ui-notification {
			color: #fff;
			background-color: #d54e21
		}

		.wp-ui-text-notification {
			color: #d54e21
		}

		.wp-ui-text-icon {
			color: #82878c
		}

		img.emoji {
			display: inline !important;
			border: none !important;
			height: 1em !important;
			width: 1em !important;
			margin: 0 .07em !important;
			vertical-align: -.1em !important;
			background: 0 0 !important;
			padding: 0 !important;
			box-shadow: none !important
		}

		#nav-menu-footer, #nav-menu-header, #your-profile #rich_editing, .checkbox, .control-section .accordion-section-title, .menu-item-handle, .postbox .hndle, .side-info, .sidebar-name, .stuffbox .hndle, .widefat tfoot td, .widefat tfoot th, .widefat thead td, .widefat thead th, .widget .widget-top {
			line-height: 1.4em
		}

		.menu-item-handle, .widget .widget-top {
			background: #fafafa;
			color: #23282d
		}

		.postbox .hndle, .stuffbox .hndle {
			border-bottom: 1px solid #eee;
			-webkit-user-select: none;
			-moz-user-select: none;
			-ms-user-select: none;
			user-select: none
		}

		.quicktags, .search {
			background-color: #ccc;
			color: #000;
			font-size: 12px
		}

		.icon32 {
			display: none
		}

		#bulk-titles div a:before, .notice-dismiss:before, .tagchecklist .ntdelbutton .remove-tag-icon:before, .welcome-panel .welcome-panel-close:before {
			background: 0 0;
			color: #72777c;
			content: "\f153";
			display: block;
			font: 400 16px/20px dashicons;
			speak: none;
			height: 20px;
			text-align: center;
			width: 20px;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale
		}

		.welcome-panel .welcome-panel-close:before {
			margin: 0
		}

		#bulk-titles div a:before {
			margin: 1px 0
		}

		.tagchecklist .ntdelbutton .remove-tag-icon:before {
			margin-left: 2px;
			border-radius: 50%;
			color: #0073aa;
			line-height: 1.28
		}

		.tagchecklist .ntdelbutton:focus {
			outline: 0
		}

		#bulk-titles div a:focus:before, #bulk-titles div a:hover:before, .tagchecklist .ntdelbutton:focus .remove-tag-icon:before, .tagchecklist .ntdelbutton:hover .remove-tag-icon:before, .welcome-panel .welcome-panel-close:focus:before, .welcome-panel .welcome-panel-close:hover:before {
			color: #c00
		}

		.tagchecklist .ntdelbutton:focus .remove-tag-icon:before {
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		.key-labels label {
			line-height: 24px
		}

		b, strong {
			font-weight: 600
		}

		.pre {
			white-space: pre-wrap
		}

		#namediv td.first, .nav-tab, .no-break, .star-rating {
			white-space: nowrap
		}

		.howto {
			color: #666;
			font-style: italic;
			display: block
		}

		p.install-help {
			margin: 8px 0;
			font-style: italic
		}

		hr {
			border: 0;
			border-top: 1px solid #ddd;
			border-bottom: 1px solid #fafafa
		}

		#all-plugins-table .plugins a.delete, #delete-link a.delete, #media-items a.delete, #media-items a.delete-permanently, #nav-menu-footer .menu-delete, #search-plugins-table .plugins a.delete, .plugins a.delete, .row-actions span.delete a, .row-actions span.spam a, .row-actions span.trash a, .submitbox .submitdelete {
			color: #a00
		}

		#all-plugins-table .plugins a.delete:hover, #delete-link a.delete:hover, #media-items a.delete-permanently:hover, #media-items a.delete:hover, #nav-menu-footer .menu-delete:hover, #search-plugins-table .plugins a.delete:hover, .file-error, .plugins a.delete:hover, .row-actions .delete a:hover, .row-actions .spam a:hover, .row-actions .trash a:hover, .submitbox .submitdelete:hover, abbr.required, span.required {
			color: #dc3232;
			border: none
		}

		#major-publishing-actions {
			padding: 10px;
			clear: both;
			border-top: 1px solid #ddd;
			background: #f5f5f5
		}

		#delete-action {
			float: left;
			line-height: 28px
		}

		#delete-link {
			line-height: 28px;
			vertical-align: middle;
			text-align: left;
			margin-left: 8px
		}

		#delete-link a {
			text-decoration: none
		}

		#publishing-action {
			text-align: right;
			float: right;
			line-height: 23px
		}

		#misc-publishing-actions {
			padding: 6px 0 0
		}

		.misc-pub-section {
			padding: 6px 10px 8px
		}

		#minor-publishing-actions {
			padding: 10px 10px 0;
			text-align: right
		}

		.preview {
			float: right
		}

		#sticky-span {
			margin-left: 18px
		}

		.approve, .unapproved .unapprove {
			display: none
		}

		.spam .approve, .trash .approve, .unapproved .approve {
			display: inline
		}

		td.action-links, th.action-links {
			text-align: right
		}

		#misc-publishing-actions .notice {
			margin-left: 10px;
			margin-right: 10px
		}

		.wp-filter {
			display: inline-block;
			position: relative;
			margin: 12px 0 25px;
			padding: 0 10px;
			width: 100%;
			box-shadow: 0 1px 1px rgba(0, 0, 0, .04);
			border: 1px solid #e5e5e5;
			background: #fff;
			color: #555;
			font-size: 13px
		}

		.wp-filter a {
			text-decoration: none
		}

		.filter-count {
			display: inline-block;
			vertical-align: middle;
			min-width: 4em
		}

		.filter-count .count, .title-count {
			display: inline-block;
			position: relative;
			top: -1px;
			padding: 4px 10px;
			border-radius: 30px;
			background: #72777c;
			color: #fff;
			font-size: 14px;
			font-weight: 600
		}

		.title-count {
			display: inline;
			top: -3px;
			margin-left: 5px;
			margin-right: 20px
		}

		.filter-links li > a, .wp-filter .search-form.search-plugins {
			display: inline-block
		}

		.filter-items {
			float: left
		}

		.filter-links, .filter-links li {
			display: inline-block;
			margin: 0
		}

		.filter-links li > a {
			margin: 0 10px;
			padding: 15px 0;
			border-bottom: 4px solid #fff;
			color: #666;
			cursor: pointer
		}

		.filter-links .current {
			box-shadow: none;
			border-bottom: 4px solid #666;
			color: #23282d
		}

		.filter-links li > a:focus, .filter-links li > a:hover, .show-filters .filter-links a.current:focus, .show-filters .filter-links a.current:hover {
			color: #00a0d2
		}

		.wp-filter .search-form {
			float: right;
			margin: 10px 0
		}

		.wp-filter .search-form input[type=search] {
			margin: 0;
			padding: 3px 5px;
			width: 280px;
			max-width: 100%;
			font-size: 16px;
			font-weight: 300;
			line-height: 1.5
		}

		.wp-filter .search-form select {
			margin: 0;
			height: 32px;
			vertical-align: top
		}

		.wp-filter .button.drawer-toggle {
			margin: 10px 9px 0;
			padding: 0 10px 0 6px;
			border-color: transparent;
			background-color: transparent;
			color: #666;
			vertical-align: baseline;
			box-shadow: none
		}

		.wp-filter .drawer-toggle:before {
			content: "\f111";
			margin: 0 5px 0 0;
			color: #72777c;
			font: 400 16px/1 dashicons;
			vertical-align: text-bottom;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale
		}

		.wp-filter .button.drawer-toggle:focus, .wp-filter .button.drawer-toggle:hover, .wp-filter .drawer-toggle:focus:before, .wp-filter .drawer-toggle:hover:before {
			background-color: transparent;
			color: #00a0d2
		}

		.wp-filter .button.drawer-toggle:focus:active, .wp-filter .button.drawer-toggle:hover {
			border-color: transparent
		}

		.wp-filter .button.drawer-toggle:focus {
			border-color: #5b9dd9
		}

		.wp-filter .button.drawer-toggle:active {
			background: 0 0;
			box-shadow: none;
			-webkit-transform: none;
			transform: none
		}

		.wp-filter .drawer-toggle.current:before {
			color: #fff
		}

		.filter-drawer, .wp-filter .favorites-form {
			display: none;
			margin: 0 -10px 0 -20px;
			padding: 20px;
			border-top: 1px solid #eee;
			background: #fafafa;
			overflow: hidden
		}

		.show-favorites-form .favorites-form, .show-filters .filter-drawer {
			display: block
		}

		.show-filters .filter-links a.current {
			border-bottom: none
		}

		.show-filters .wp-filter .button.drawer-toggle {
			border-radius: 2px;
			background: #72777c;
			color: #fff
		}

		.filter-group, .filtered-by .tag {
			border: 1px solid #e5e5e5;
			box-shadow: 0 1px 1px rgba(0, 0, 0, .04)
		}

		.show-filters .wp-filter .drawer-toggle:focus, .show-filters .wp-filter .drawer-toggle:hover {
			background: #2ea2cc
		}

		.show-filters .wp-filter .drawer-toggle:before {
			color: #fff
		}

		.filter-group {
			position: relative;
			float: left;
			margin: 0 1% 0 0;
			padding: 20px 10px 10px;
			width: 24%;
			background: #fff
		}

		.filter-group legend {
			position: absolute;
			top: 10px;
			display: block;
			margin: 0;
			padding: 0;
			font-size: 1em;
			font-weight: 600
		}

		.filter-drawer .filter-group-feature {
			margin: 28px 0 0;
			list-style-type: none;
			font-size: 12px
		}

		.filter-drawer .filter-group-feature input, .filter-drawer .filter-group-feature label {
			display: inline-block;
			margin: 7px 4px 7px 0;
			line-height: 16px
		}

		.filter-drawer .buttons {
			clear: both;
			margin-bottom: 20px
		}

		.filter-drawer .filter-group + .buttons {
			margin-bottom: 0;
			padding-top: 20px
		}

		.filter-drawer .buttons .button span {
			display: inline-block;
			opacity: .8;
			font-size: 12px;
			text-indent: 10px
		}

		.wp-filter .button.clear-filters {
			display: none;
			margin-left: 10px
		}

		.wp-filter .button-link.edit-filters {
			padding: 0 5px;
			line-height: 28px
		}

		.filtered-by {
			display: none;
			margin: 0
		}

		.filtered-by > span {
			font-weight: 600
		}

		.filtered-by a {
			margin-left: 10px
		}

		.filtered-by .tags {
			display: inline
		}

		.filtered-by .tag {
			margin: 0 5px;
			padding: 4px 8px;
			background: #fff;
			font-size: 11px
		}

		.filters-applied .filter-drawer .buttons, .filters-applied .filter-drawer br, .filters-applied .filter-group {
			display: none !important
		}

		.filters-applied .filtered-by {
			display: block
		}

		.filters-applied .filter-drawer {
			padding: 20px
		}

		.error .content-filterable, .loading-content .content-filterable, .show-filters .content-filterable, .show-filters .favorites-form, .show-filters.filters-applied.loading-content .content-filterable {
			display: none
		}

		.show-filters.filters-applied .content-filterable {
			display: block
		}

		.loading-content .spinner {
			display: block;
			margin: 40px auto 0;
			float: none
		}

		@media only screen and (max-width: 1120px) {
			.filter-drawer {
				border-bottom: 1px solid #eee
			}

			.filter-group {
				margin-bottom: 0;
				margin-top: 5px;
				width: 100%
			}

			.filter-group li {
				margin: 10px 0
			}
		}

		@media only screen and (max-width: 1000px) {
			.filter-items {
				float: none
			}

			.wp-filter .media-toolbar-primary, .wp-filter .media-toolbar-secondary, .wp-filter .search-form {
				float: none;
				position: relative;
				max-width: 100%
			}
		}

		@media only screen and (max-width: 782px) {
			.filter-group li {
				padding: 0;
				width: 50%
			}
		}

		@media only screen and (max-width: 320px) {
			.filter-count {
				display: none
			}

			.wp-filter .drawer-toggle {
				margin: 10px 0
			}

			.filter-group li, .wp-filter .search-form input[type=search] {
				width: 100%
			}
		}

		.notice, div.error, div.updated {
			background: #fff;
			border-left: 4px solid #fff;
			box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
			margin: 5px 15px 2px;
			padding: 1px 12px
		}

		div[class=update-message] {
			padding: .5em 12px .5em 0
		}

		.form-table td .notice p, .notice p, .notice-title, div.error p, div.updated p {
			margin: .5em 0;
			padding: 2px
		}

		.error a {
			text-decoration: underline
		}

		.updated a {
			padding-bottom: 2px
		}

		.notice-alt {
			box-shadow: none
		}

		.notice-large {
			padding: 10px 20px
		}

		.notice-title {
			display: inline-block;
			color: #23282d;
			font-size: 18px
		}

		.wp-core-ui .notice.is-dismissible {
			padding-right: 38px;
			position: relative
		}

		.notice-dismiss {
			position: absolute;
			top: 0;
			right: 1px;
			border: none;
			margin: 0;
			padding: 9px;
			background: 0 0;
			color: #72777c;
			cursor: pointer
		}

		.notice-dismiss:active:before, .notice-dismiss:focus:before, .notice-dismiss:hover:before {
			color: #c00
		}

		.notice-dismiss:focus {
			outline: 0;
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		.ie8 .notice-dismiss:focus {
			outline: #5b9dd9 solid 1px
		}

		.notice-success, div.updated {
			border-left-color: #46b450
		}

		.notice-success.notice-alt {
			background-color: #ecf7ed
		}

		.notice-warning {
			border-left-color: #ffb900
		}

		.notice-warning.notice-alt {
			background-color: #fff8e5
		}

		.notice-error, div.error {
			border-left-color: #dc3232
		}

		.notice-error.notice-alt {
			background-color: #fbeaea
		}

		.notice-info {
			border-left-color: #00a0d2
		}

		.notice-info.notice-alt {
			background-color: #e5f5fa
		}

		.button.installed:before, .button.installing:before, .button.updated-message:before, .button.updating-message:before, .import-php .updating-message:before, .update-message p:before, .updated-message p:before, .updating-message p:before {
			display: inline-block;
			font: 400 20px/1 dashicons;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			vertical-align: top
		}

		.media-upload-form .notice, .media-upload-form div.error, .wrap .notice, .wrap div.error, .wrap div.updated {
			margin: 5px 0 15px
		}

		.wrap #templateside .notice {
			display: block;
			margin: 0;
			padding: 5px 8px;
			font-weight: 600;
			text-decoration: none
		}

		.wrap #templateside span.notice {
			margin-left: -12px
		}

		#templateside li.notice a {
			padding: 0
		}

		.button.installing:before, .button.updating-message:before, .import-php .updating-message:before, .update-message p:before, .updating-message p:before {
			color: #f56e28;
			content: "\f463"
		}

		.button.installing:before, .button.updating-message:before, .import-php .updating-message:before, .updating-message p:before {
			-webkit-animation: rotation 2s infinite linear;
			animation: rotation 2s infinite linear
		}

		.button.updated-message:before, .installed p:before, .updated-message p:before {
			color: #79ba49;
			content: '\f147'
		}

		.update-message.notice-error p:before {
			color: #dc3232;
			content: "\f534"
		}

		.import-php .updating-message:before, .wrap .notice p:before {
			margin-right: 6px;
			vertical-align: bottom
		}

		#update-nag, .update-nag {
			display: inline-block;
			line-height: 19px;
			padding: 11px 15px;
			font-size: 14px;
			text-align: left;
			margin: 25px 20px 0 2px;
			background-color: #fff;
			border-left: 4px solid #ffba00;
			box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1)
		}

		#screen-meta, ul#dismissed-updates {
			display: none
		}

		form.upgrade {
			margin-top: 8px
		}

		form.upgrade .hint {
			font-style: italic;
			font-size: 85%;
			margin: -.5em 0 2em
		}

		.update-php .spinner {
			float: none;
			margin: -4px 0
		}

		#ajax-response.alignleft {
			margin-left: 2em
		}

		.button.installed:before, .button.installing:before, .button.updated-message:before, .button.updating-message:before {
			margin: 3px 5px 0 -2px
		}

		.button-primary.updating-message:before {
			color: #fff
		}

		.button-primary.updated-message:before {
			color: #66c6e4
		}

		@media aural {
			.button.installed:before, .button.installing:before, .update-message p:before, .wrap .notice p:before {
				speak: none
			}
		}

		#adminmenu a, #catlist a, #taglist a {
			text-decoration: none
		}

		#contextual-help-wrap, #screen-options-wrap {
			margin: 0;
			padding: 8px 20px 12px;
			position: relative
		}

		#contextual-help-wrap {
			overflow: auto;
			margin-left: 0 !important
		}

		#screen-meta-links {
			margin: 0 20px 0 0
		}

		#screen-meta {
			margin: 0 20px -1px 0;
			position: relative;
			background-color: #fff;
			border: 1px solid #ddd;
			border-top: none;
			box-shadow: 0 1px 0 rgba(0, 0, 0, .025)
		}

		#contextual-help-link-wrap, #screen-options-link-wrap {
			float: right;
			height: 28px;
			margin: 0 0 0 6px;
			border: 1px solid #ddd;
			border-top: none;
			background: #fff;
			box-shadow: 0 1px 1px -1px rgba(0, 0, 0, .1)
		}

		#screen-meta-links .screen-meta-toggle {
			position: relative;
			top: 0
		}

		#screen-meta-links .show-settings {
			border: 0;
			background: 0 0;
			border-radius: 0;
			color: #72777c;
			line-height: 1.7;
			padding: 3px 6px 3px 16px
		}

		#screen-meta-links .show-settings:active, #screen-meta-links .show-settings:focus, #screen-meta-links .show-settings:hover {
			color: #32373c
		}

		#screen-meta-links .show-settings:active {
			box-shadow: none;
			-webkit-transform: none;
			transform: none
		}

		#screen-meta-links .show-settings:after {
			right: 0;
			content: "\f140";
			font: 400 20px/1 dashicons;
			speak: none;
			display: inline-block;
			padding: 0 5px 0 0;
			bottom: 2px;
			position: relative;
			vertical-align: bottom;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			text-decoration: none !important;
			color: #72777c
		}

		#templateside ul li a, .contextual-help-tabs a, .nav-tab {
			text-decoration: none
		}

		#screen-meta-links .screen-meta-active:after {
			content: "\f142"
		}

		.toggle-arrow {
			background-repeat: no-repeat;
			background-position: top left;
			background-color: transparent;
			height: 22px;
			line-height: 22px;
			display: block
		}

		.toggle-arrow-active {
			background-position: bottom left
		}

		#contextual-help-wrap h5, #screen-options-wrap h5, #screen-options-wrap legend {
			margin: 0;
			padding: 8px 0;
			font-size: 13px;
			font-weight: 600
		}

		.hndle a, .widefat tfoot td, .widefat th, .widefat thead td {
			font-weight: 400
		}

		.ie8 #screen-options-wrap legend {
			color: inherit
		}

		.metabox-prefs label {
			display: inline-block;
			padding-right: 15px;
			line-height: 30px
		}

		#number-of-columns {
			display: inline-block;
			vertical-align: middle;
			line-height: 30px
		}

		.metabox-prefs input[type=checkbox] {
			margin-top: 0;
			margin-right: 6px
		}

		.metabox-prefs label input, .metabox-prefs label input[type=checkbox] {
			margin: -4px 5px 0 0
		}

		.metabox-prefs .columns-prefs label input {
			margin: -1px 2px 0 0
		}

		.metabox-prefs label a {
			display: none
		}

		.metabox-prefs .screen-options input, .metabox-prefs .screen-options label {
			margin-top: 0;
			margin-bottom: 0;
			vertical-align: middle
		}

		.metabox-prefs .screen-options .screen-per-page {
			margin-right: 15px
		}

		.metabox-prefs .screen-options label {
			line-height: 28px;
			padding-right: 0
		}

		.screen-options + .screen-options {
			margin-top: 10px
		}

		.metabox-prefs .submit {
			margin-top: 1em;
			padding: 0
		}

		#contextual-help-wrap {
			padding: 0
		}

		#contextual-help-columns {
			position: relative
		}

		#contextual-help-back {
			position: absolute;
			top: 0;
			bottom: 0;
			left: 150px;
			right: 170px;
			border: 1px solid #e1e1e1;
			border-top: none;
			border-bottom: none;
			background: #f6fbfd
		}

		#contextual-help-wrap.no-sidebar #contextual-help-back {
			right: 0;
			border-right-width: 0;
			border-bottom-right-radius: 2px
		}

		.contextual-help-tabs {
			float: left;
			width: 150px;
			margin: 0
		}

		.contextual-help-tabs ul {
			margin: 1em 0
		}

		.contextual-help-tabs li {
			margin-bottom: 0;
			list-style-type: none;
			border-style: solid;
			border-width: 0 0 0 2px;
			border-color: transparent
		}

		.contextual-help-tabs a {
			display: block;
			padding: 5px 5px 5px 12px;
			line-height: 18px;
			border: 1px solid transparent;
			border-right: none;
			border-left: none
		}

		.contextual-help-tabs a:hover {
			color: #32373c
		}

		.contextual-help-tabs .active {
			padding: 0;
			margin: 0 -1px 0 0;
			border-left: 2px solid #00a0d2;
			background: #f6fbfd;
			box-shadow: 0 2px 0 rgba(0, 0, 0, .02), 0 1px 0 rgba(0, 0, 0, .02)
		}

		.contextual-help-tabs .active a {
			border-color: #e1e1e1;
			color: #32373c
		}

		.contextual-help-tabs-wrap {
			padding: 0 20px;
			overflow: auto
		}

		.help-tab-content {
			display: none;
			margin: 0 22px 12px 0;
			line-height: 1.6em
		}

		.help-tab-content.active {
			display: block
		}

		.help-tab-content ul li {
			list-style-type: disc;
			margin-left: 18px
		}

		.contextual-help-sidebar {
			width: 150px;
			float: right;
			padding: 0 8px 0 12px;
			overflow: auto
		}

		html.wp-toolbar {
			padding-top: 32px
		}

		.widefat td, .widefat th {
			color: #555
		}

		.widefat ol, .widefat p, .widefat tfoot tr td, .widefat tfoot tr th, .widefat thead tr td, .widefat thead tr th, .widefat ul {
			color: #32373c
		}

		.widefat td p {
			margin: 2px 0 .8em
		}

		.widefat .column-comment p {
			margin: .6em 0
		}

		.widefat .column-comment ul {
			list-style: outside;
			margin-left: 2em
		}

		.postbox-container {
			float: left
		}

		#wpbody-content .metabox-holder {
			padding-top: 10px
		}

		.metabox-holder .postbox-container .empty-container {
			border: 3px dashed #b4b9be;
			height: 250px;
			position: relative
		}

		.metabox-holder .postbox-container .empty-container:after {
			content: attr(data-emptystring);
			margin: auto;
			position: absolute;
			top: 0;
			left: 0;
			bottom: 0;
			right: 0;
			height: 1em;
			width: 200px;
			text-align: center;
			color: #ccc;
			font-size: 18px;
			display: none
		}

		.columns-2 #postbox-container-3 .empty-container, .columns-2 #postbox-container-4 .empty-container, .columns-3 #postbox-container-4 .empty-container, .metabox-holder.columns-1 .postbox-container .empty-container {
			border: 0;
			height: 0;
			min-height: 0
		}

		#post-body-content {
			width: 100%;
			min-width: 463px;
			float: left
		}

		#post-body.columns-2 #postbox-container-1 {
			float: right;
			margin-right: -300px;
			width: 280px
		}

		#post-body.columns-2 #side-sortables {
			min-height: 250px
		}

		@media only screen and (max-width: 799px) {
			#wpbody-content .metabox-holder .postbox-container .empty-container {
				border: 0;
				height: 0;
				min-height: 0
			}
		}

		.js .postbox .hndle, .js .widget .widget-top {
			cursor: move
		}

		.hndle a {
			font-size: 11px
		}

		#adminmenu .wp-submenu li.current, #adminmenu .wp-submenu li.current a, #adminmenu .wp-submenu li.current a:hover, #dashboard_right_now .versions .b, #ed_reply_toolbar #ed_reply_strong, #pass-strength-result.short, #pass-strength-result.strong, #post-status-display, #post-visibility-display, .feature-filter .feature-name, .item-controls .item-order a, .media-item .percent, .nav-tab, .plugins .name {
			font-weight: 600
		}

		.postbox .handlediv {
			display: none;
			float: right;
			width: 36px;
			height: 36px;
			margin: 0;
			padding: 0;
			border: 0;
			background: 0 0;
			cursor: pointer
		}

		.js .postbox .handlediv {
			display: block
		}

		.sortable-placeholder {
			border: 1px dashed #b4b9be;
			margin-bottom: 20px
		}

		.postbox, .stuffbox {
			margin-bottom: 20px;
			padding: 0;
			line-height: 1
		}

		.postbox .inside, .stuffbox .inside {
			padding: 0 12px 12px;
			line-height: 1.4em;
			font-size: 13px
		}

		.postbox .inside {
			margin: 11px 0;
			position: relative
		}

		.postbox .inside > p:last-child, .rss-widget ul li:last-child {
			margin-bottom: 1px !important
		}

		.postbox.closed h3 {
			border: none;
			box-shadow: none
		}

		.postbox table.form-table {
			margin-bottom: 0
		}

		.postbox table.widefat {
			box-shadow: none
		}

		.temp-border {
			border: 1px dotted #ccc
		}

		.columns-prefs label {
			padding: 0 10px 0 0
		}

		#wpfooter {
			position: absolute;
			bottom: 0;
			left: 0;
			right: 0;
			padding: 10px 20px;
			color: #555d66
		}

		#wpfooter p {
			font-size: 13px;
			margin: 0;
			line-height: 20px
		}

		#footer-thankyou {
			font-style: italic
		}

		.nav-tab {
			float: left;
			border: 1px solid #ccc;
			border-bottom: none;
			margin-left: .5em;
			padding: 5px 10px;
			font-size: 14px;
			line-height: 24px;
			background: #e5e5e5;
			color: #555
		}

		.nav-tab-small .nav-tab, h3 .nav-tab {
			padding: 5px 14px;
			font-size: 12px;
			line-height: 16px
		}

		.nav-tab:focus, .nav-tab:hover {
			background-color: #fff;
			color: #444
		}

		.nav-tab-active, .nav-tab:focus:active {
			box-shadow: none
		}

		.nav-tab-active {
			margin-bottom: -1px;
			color: #444
		}

		.nav-tab-active, .nav-tab-active:focus, .nav-tab-active:focus:active, .nav-tab-active:hover {
			border-bottom: 1px solid #f1f1f1;
			background: #f1f1f1;
			color: #000
		}

		.nav-tab-wrapper, .wrap h2.nav-tab-wrapper, h1.nav-tab-wrapper {
			border-bottom: 1px solid #ccc;
			margin: 0;
			padding-top: 9px;
			padding-bottom: 0;
			line-height: inherit
		}

		.nav-tab-wrapper:not(.wp-clearfix):after {
			content: "";
			display: table;
			clear: both
		}

		.ie8 .nav-tab-wrapper {
			display: inline-block;
			width: 100%;
			vertical-align: top
		}

		.spinner {
			background: url(images/spinner.gif) no-repeat;
			background-size: 20px 20px;
			display: inline-block;
			float: right;
			vertical-align: middle;
			opacity: .7;
			filter: alpha(opacity=70);
			width: 20px;
			height: 20px;
			margin: 4px 10px 0
		}

		.loading-content .spinner, .spinner.is-active {
			visibility: visible
		}

		#template > div {
			margin-right: 16em
		}

		#template .notice {
			margin-top: 1em;
			margin-right: 3%
		}

		#template .notice p {
			width: auto
		}

		#template .submit .spinner {
			float: none
		}

		.metabox-holder .postbox > h3, .metabox-holder .stuffbox > h3, .metabox-holder h2.hndle, .metabox-holder h3.hndle {
			font-size: 14px;
			padding: 8px 12px;
			margin: 0;
			line-height: 1.4
		}

		.nav-menus-php .metabox-holder h3 {
			padding: 10px 10px 11px 14px;
			line-height: 21px
		}

		.plugin-install #description, .plugin-install-network #description {
			width: 60%
		}

		table .column-rating, table .column-visible, table .vers {
			text-align: left
		}

		.attention, .error-message {
			color: #dc3232;
			font-weight: 600
		}

		body.iframe {
			height: 98%
		}

		.lp-show-latest p {
			display: none
		}

		#howto, .importer-action, .importer-desc, .importer-title {
			display: block
		}

		.lp-show-latest .lp-error p, .lp-show-latest p:last-child {
			display: block
		}

		.media-icon {
			width: 62px;
			text-align: center
		}

		.media-icon img {
			border: 1px solid #e5e5e5;
			border: 1px solid rgba(0, 0, 0, .07)
		}

		#howto {
			font-size: 11px;
			margin: 0 5px
		}

		.importers {
			font-size: 16px;
			width: auto
		}

		.importers td {
			padding-right: 14px;
			line-height: 1.5em
		}

		.importers .import-system {
			max-width: 250px
		}

		.importers td.desc {
			max-width: 500px
		}

		.post-categories, .post-categories li {
			display: inline
		}

		.importer-title {
			color: #000;
			font-size: 14px;
			font-weight: 400;
			margin-bottom: .2em
		}

		.importer-action {
			line-height: 20px;
			color: #555;
			margin-bottom: 1em
		}

		#post-body #post-body-content #namediv h2, #post-body #post-body-content #namediv h3 {
			margin-top: 0
		}

		.edit-comment-author {
			font-size: 14px;
			line-height: 1.4;
			font-weight: 600;
			color: #222;
			margin: 2px 0 0 9px
		}

		#namediv h2 label, #namediv h3 label {
			vertical-align: baseline
		}

		#namediv table {
			width: 100%
		}

		#namediv td.first {
			width: 10px
		}

		#namediv input {
			width: 98%
		}

		#namediv p {
			margin: 10px 0
		}

		#submitdiv h3 {
			margin-bottom: 0 !important
		}

		.checkbox, .post-categories, .zerosize, fieldset {
			margin: 0;
			padding: 0
		}

		.zerosize {
			height: 0;
			width: 0;
			border: 0;
			overflow: hidden;
			position: absolute
		}

		br.clear {
			height: 2px;
			line-height: 2px
		}

		.checkbox {
			border: none
		}

		fieldset {
			border: 0
		}

		div.star-holder {
			position: relative;
			height: 17px;
			width: 100px;
			background: url(images/stars.png?ver=20121108) bottom left repeat-x
		}

		div.star-holder .star-rating {
			background: url(images/stars.png?ver=20121108) top left repeat-x;
			height: 17px;
			float: left
		}

		.star-rating .star {
			display: inline-block;
			width: 20px;
			height: 20px;
			-webkit-font-smoothing: antialiased;
			font-size: 20px;
			line-height: 1;
			font-family: dashicons;
			text-decoration: inherit;
			font-weight: 400;
			font-style: normal;
			vertical-align: top;
			transition: color .1s ease-in 0;
			text-align: center;
			color: #ffb900
		}

		.star-rating .star-full:before {
			content: "\f155"
		}

		.star-rating .star-half:before {
			content: "\f459"
		}

		.rtl .star-rating .star-half {
			-webkit-transform: rotateY(180deg);
			transform: rotateY(180deg)
		}

		.star-rating .star-empty:before {
			content: "\f154"
		}

		div.action-links {
			font-weight: 400;
			margin: 6px 0 0
		}

		#plugin-information {
			background: #fff;
			position: fixed;
			top: 0;
			right: 0;
			bottom: 0;
			left: 0;
			height: 100%;
			padding: 0
		}

		#plugin-information-scrollable {
			overflow: auto;
			-webkit-overflow-scrolling: touch;
			height: 100%
		}

		#plugin-information-title {
			padding: 0 26px;
			background: #f5f5f5;
			font-size: 22px;
			font-weight: 600;
			line-height: 56px;
			position: relative;
			height: 56px
		}

		#plugin-information-title.with-banner {
			margin-right: 0;
			height: 250px;
			background-size: cover
		}

		#plugin-information-title h2 {
			font-size: 1em;
			font-weight: 600;
			padding: 0;
			margin: 0;
			overflow: hidden;
			text-overflow: ellipsis;
			white-space: nowrap
		}

		#plugin-information-title.with-banner h2 {
			position: relative;
			font-family: "Helvetica Neue", sans-serif;
			display: inline-block;
			font-size: 30px;
			line-height: 50px;
			box-sizing: border-box;
			max-width: 100%;
			padding: 0 15px;
			margin-top: 174px;
			color: #fff;
			background: rgba(30, 30, 30, .9);
			text-shadow: 0 1px 3px rgba(0, 0, 0, .4);
			box-shadow: 0 0 30px rgba(255, 255, 255, .1);
			border-radius: 8px
		}

		#plugin-information-title div.vignette {
			display: none
		}

		#plugin-information-title.with-banner div.vignette {
			position: absolute;
			display: block;
			top: 0;
			left: 0;
			height: 250px;
			width: 100%;
			background: 0 0;
			box-shadow: inset 0 0 50px 4px rgba(0, 0, 0, .2), inset 0 -1px 0 rgba(0, 0, 0, .1)
		}

		#plugin-information-tabs {
			padding: 0 16px;
			position: relative;
			right: 0;
			left: 0;
			min-height: 36px;
			font-size: 0;
			z-index: 1;
			border-bottom: 1px solid #ddd;
			background: #f3f3f3
		}

		#plugin-information-tabs a {
			position: relative;
			display: inline-block;
			padding: 9px 10px;
			margin: 0;
			height: 18px;
			line-height: 18px;
			font-size: 14px;
			text-decoration: none;
			transition: none
		}

		#plugin-information-tabs a.current {
			margin: 0 -1px -1px;
			background: #fff;
			border: 1px solid #ddd;
			border-bottom-color: #fff;
			padding-top: 8px;
			color: #32373c
		}

		#plugin-information-tabs.with-banner a.current {
			border-top: none;
			padding-top: 9px
		}

		#plugin-information-tabs a:active, #plugin-information-tabs a:focus {
			outline: 0
		}

		#plugin-information-content {
			overflow: hidden;
			background: #fff;
			position: relative;
			top: 0;
			right: 0;
			left: 0;
			min-height: 100%;
			min-height: calc(100% - 152px)
		}

		#plugin-information-content.with-banner {
			min-height: calc(100% - 346px)
		}

		#section-holder {
			position: relative;
			top: 0;
			right: 250px;
			bottom: 0;
			left: 0;
			margin-right: 250px;
			padding: 10px 26px 99999px;
			margin-bottom: -99939px
		}

		#section-holder .updated {
			margin: 16px 0
		}

		#plugin-information .fyi {
			float: right;
			position: relative;
			top: 0;
			right: 0;
			padding: 16px 16px 99999px;
			margin-bottom: -99939px;
			width: 217px;
			border-left: 1px solid #ddd;
			background: #f3f3f3;
			color: #666
		}

		#plugin-information .fyi strong {
			color: #444
		}

		#plugin-information .fyi h3 {
			font-weight: 600;
			text-transform: uppercase;
			font-size: 12px;
			color: #666;
			margin: 24px 0 8px
		}

		#plugin-information .fyi h2 {
			font-size: .9em;
			margin-bottom: 0;
			margin-right: 0
		}

		#plugin-information .fyi ul {
			padding: 0;
			margin: 0;
			list-style: none
		}

		#plugin-information .fyi li {
			margin: 0 0 10px
		}

		#plugin-information .fyi-description {
			margin-top: 0
		}

		#plugin-information .counter-container {
			margin: 3px 0
		}

		#plugin-information .counter-label {
			float: left;
			margin-right: 5px;
			min-width: 55px
		}

		#plugin-information .counter-back {
			height: 17px;
			width: 92px;
			background-color: #e5e5e5;
			float: left
		}

		#plugin-information .counter-bar {
			height: 17px;
			background-color: #ffc733;
			float: left
		}

		#plugin-information .counter-count {
			margin-left: 5px
		}

		#plugin-information .fyi ul.contributors {
			margin-top: 10px
		}

		#plugin-information .fyi ul.contributors li {
			display: inline-block;
			margin-right: 8px;
			vertical-align: middle
		}

		#plugin-information .fyi ul.contributors li img {
			vertical-align: middle;
			margin-right: 4px
		}

		#plugin-information-footer {
			padding: 13px 16px;
			position: absolute;
			right: 0;
			bottom: 0;
			left: 0;
			height: 33px;
			border-top: 1px solid #ddd;
			background: #f3f3f3
		}

		#plugin-information .section ol, #plugin-information .section ul {
			list-style-type: disc;
			margin-left: 24px
		}

		#plugin-information .section, #plugin-information .section p {
			font-size: 14px;
			line-height: 1.7
		}

		#plugin-information #section-screenshots ol {
			list-style: none;
			margin: 0
		}

		#plugin-information #section-screenshots li img {
			vertical-align: text-top;
			margin-top: 16px;
			max-width: 100%;
			width: auto;
			height: auto;
			box-shadow: 0 1px 2px rgba(0, 0, 0, .3)
		}

		#plugin-information #section-screenshots li p {
			font-style: italic;
			padding-left: 20px
		}

		#plugin-information pre {
			padding: 7px;
			overflow: auto;
			border: 1px solid #ccc
		}

		#plugin-information blockquote {
			border-left: 2px solid #ddd;
			color: #666;
			font-style: italic;
			margin: 1em 0;
			padding: 0 0 0 1em
		}

		#plugin-information .review {
			overflow: hidden;
			width: 100%;
			margin-bottom: 20px;
			border-bottom: 1px solid #e5e5e5
		}

		#plugin-information .review-title-section {
			overflow: hidden
		}

		#plugin-information .review-title-section h4 {
			display: inline-block;
			float: left;
			margin: 0 6px 0 0
		}

		#plugin-information .reviewer-info p {
			clear: both;
			margin: 0;
			padding-top: 2px
		}

		#plugin-information .reviewer-info .avatar {
			float: left;
			margin: 4px 6px 0 0
		}

		#plugin-information .reviewer-info .star-rating {
			float: left
		}

		#plugin-information .review-meta {
			float: left;
			margin-left: .75em
		}

		#plugin-information .review-body {
			float: left;
			width: 100%
		}

		.plugin-version-author-uri {
			font-size: 13px
		}

		.update-php .button.button-primary {
			margin-right: 1em
		}

		@media screen and (max-width: 771px) {
			#plugin-information-title.with-banner, #plugin-information-title.with-banner div.vignette {
				height: 100px
			}

			#plugin-information-title.with-banner h2 {
				margin-top: 30px;
				font-size: 20px;
				line-height: 40px;
				max-width: 85%
			}

			#plugin-information-tabs {
				overflow: hidden;
				padding: 0;
				height: auto
			}

			#plugin-information-tabs a.current {
				margin-bottom: 0;
				border-bottom: none
			}

			#plugin-information .fyi {
				float: none;
				border: 1px solid #ddd;
				position: static;
				width: auto;
				margin: 26px 26px 0;
				padding-bottom: 0
			}

			#section-holder {
				position: static;
				margin: 0;
				padding-bottom: 70px
			}

			#plugin-information .fyi h3, #plugin-information .fyi small {
				display: none
			}

			#plugin-information-footer {
				padding: 12px 16px 0;
				height: 46px
			}
		}

		#TB_window.plugin-details-modal {
			background: #fcfcfc
		}

		#TB_window.plugin-details-modal.thickbox-loading:before {
			content: "";
			display: block;
			width: 20px;
			height: 20px;
			position: absolute;
			left: 50%;
			top: 50%;
			z-index: -1;
			margin: -10px 0 0 -10px;
			background: url(images/spinner.gif) center no-repeat #fcfcfc;
			background-size: 20px 20px;
			-webkit-transform: translateZ(0);
			transform: translateZ(0)
		}

		.plugin-details-modal #TB_ajaxWindowTitle, .plugin-details-modal .tb-close-icon {
			display: none
		}

		.tree-folder, [role=treeitem] li {
			position: relative
		}

		@media print,(-webkit-min-device-pixel-ratio: 1.25),(min-resolution: 120dpi) {
			#TB_window.plugin-details-modal.thickbox-loading:before {
				background-image: url(images/spinner-2x.gif)
			}
		}

		.plugin-details-modal #TB_title {
			float: left;
			height: 1px
		}

		.plugin-details-modal #TB_closeWindowButton {
			left: auto;
			right: -30px;
			color: #eee
		}

		.plugin-details-modal #TB_closeWindowButton:focus, .plugin-details-modal #TB_closeWindowButton:hover {
			color: #00a0d2;
			outline: 0;
			box-shadow: none
		}

		.plugin-details-modal #TB_closeWindowButton:after {
			content: "\f335";
			font: 400 32px/29px dashicons;
			speak: none;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale
		}

		@media screen and (max-width: 830px) {
			.plugin-details-modal #TB_closeWindowButton {
				right: 0;
				top: -30px
			}
		}

		img {
			border: none
		}

		.bulk-action-notice .toggle-indicator:before, .js .meta-box-sortables .postbox .toggle-indicator:before, .sidebar-name .toggle-indicator:before {
			content: "\f142";
			display: inline-block;
			font: 400 20px/1 dashicons;
			speak: none;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			text-decoration: none !important
		}

		.bulk-action-notice .bulk-action-errors-collapsed .toggle-indicator:before, .js .meta-box-sortables .postbox.closed .handlediv .toggle-indicator:before, .js .widgets-holder-wrap.closed .toggle-indicator:before {
			content: "\f140"
		}

		.js .postbox .handlediv .toggle-indicator:before {
			margin-top: 4px;
			width: 20px;
			border-radius: 50%;
			text-indent: -1px
		}

		#template .CodeMirror, #template textarea, #templateside > ul {
			box-sizing: border-box;
			min-height: 60vh;
			height: calc(100vh - 295px);
			border: 1px solid #ddd
		}

		.rtl.js .postbox .handlediv .toggle-indicator:before {
			text-indent: 1px
		}

		.bulk-action-notice .toggle-indicator:before {
			line-height: 16px;
			vertical-align: top;
			color: #72777c
		}

		.js .postbox .handlediv:focus {
			box-shadow: none;
			outline: 0
		}

		.js .postbox .handlediv:focus .toggle-indicator:before {
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		#photo-add-url-div input[type=text] {
			width: 300px
		}

		.alignleft h2 {
			margin: 0
		}

		#template textarea {
			font-family: Consolas, Monaco, monospace;
			font-size: 13px;
			background: #f9f9f9;
			-moz-tab-size: 4;
			-o-tab-size: 4;
			tab-size: 4
		}

		#template .CodeMirror, #template textarea {
			width: 100%
		}

		#templateside > h2 {
			padding-top: 6px;
			padding-bottom: 7px;
			margin: 0
		}

		#templateside ol, #templateside ul {
			margin: 0;
			padding: 0
		}

		#templateside > ul {
			margin-top: 0;
			overflow: auto;
			padding: 0;
			background-color: #f7f7f7;
			border-left: none
		}

		#templateside ul ul {
			padding-left: 12px
		}

		#templateside > ul > li > ul[role=group] {
			padding-left: 0
		}

		[role=treeitem][aria-expanded=false] > ul {
			display: none
		}

		[role=treeitem] span[aria-hidden] {
			display: inline;
			font-family: dashicons;
			font-size: 20px;
			position: absolute;
			pointer-events: none
		}

		[role=treeitem][aria-expanded=false] > .folder-label .icon:after {
			content: "\f139"
		}

		[role=treeitem][aria-expanded=true] > .folder-label .icon:after {
			content: "\f140"
		}

		[role=treeitem] .folder-label {
			display: block;
			padding: 3px 3px 3px 12px;
			cursor: pointer
		}

		[role=treeitem] {
			outline: 0
		}

		[role=treeitem] .folder-label.focus {
			color: #124964;
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		[role=treeitem] .folder-label.hover, [role=treeitem].hover {
			background-color: #eaeaea
		}

		.tree-folder {
			margin: 0
		}

		.tree-folder .tree-folder::after {
			content: ' ';
			display: block;
			position: absolute;
			left: 2px;
			border-left: 1px solid #ccc;
			top: -13px;
			bottom: 10px
		}

		.tree-folder > li::before {
			content: ' ';
			position: absolute;
			display: block;
			border-left: 1px solid #ccc;
			left: 2px;
			top: -5px;
			height: 18px;
			width: 7px;
			border-bottom: 1px solid #ccc
		}

		.tree-folder > li::after {
			content: ' ';
			position: absolute;
			display: block;
			border-left: 1px solid #ccc;
			left: 2px;
			bottom: -7px;
			top: 0
		}

		#templateside .current-file {
			margin: -4px 0 -2px
		}

		.tree-folder > .current-file::before {
			left: 4px;
			height: 15px;
			width: 0;
			border-left: none;
			top: 3px
		}

		.tree-folder > .current-file::after {
			bottom: -4px;
			height: 7px;
			left: 2px;
			top: auto
		}

		.tree-folder li:last-child > .tree-folder::after, .tree-folder > li:last-child::after {
			display: none
		}

		#theme-plugin-editor-label {
			display: inline-block;
			margin-bottom: 1em;
			font-weight: 600
		}

		.fileedit-sub #plugin, .fileedit-sub #theme {
			max-width: 40%
		}

		.fileedit-sub .alignright {
			text-align: right
		}

		#template p {
			width: 97%
		}

		#file-editor-linting-error {
			margin-top: 1em;
			margin-bottom: 1em
		}

		#file-editor-linting-error > .notice {
			margin: 0;
			display: inline-block
		}

		#file-editor-linting-error > .notice > p {
			width: auto
		}

		#template .submit {
			margin-top: 1em;
			padding: 0
		}

		#template .submit input[type=submit][disabled] {
			cursor: not-allowed
		}

		#templateside {
			float: right;
			width: 16em
		}

		#postcustomstuff p.submit {
			margin: 0
		}

		#templateside h4 {
			margin: 1em 0 0
		}

		#templateside li {
			margin: 4px 0
		}

		#templateside li:not(.howto) a, .theme-editor-php .highlight {
			display: block;
			padding: 3px 0 3px 12px;
			text-decoration: none
		}

		#templateside li:not(.howto) > a:first-of-type {
			padding-top: 0
		}

		#templateside li.howto {
			padding: 6px 12px 12px
		}

		.theme-editor-php .highlight {
			margin: -3px 3px -3px -12px
		}

		#templateside .highlight {
			border: none;
			font-weight: 600
		}

		.nonessential {
			color: #666;
			font-size: 11px;
			font-style: italic;
			padding-left: 12px
		}

		#documentation {
			margin-top: 10px
		}

		#documentation label {
			line-height: 22px;
			vertical-align: baseline;
			font-weight: 600
		}

		.fileedit-sub {
			padding: 10px 0 8px;
			line-height: 180%
		}

		#file-editor-warning .file-editor-warning-content {
			margin: 25px
		}

		.accordion-section-title:after, .control-section .accordion-section-title:after, .nav-menus-php .item-edit:before, .widget-top .widget-action .toggle-indicator:before {
			content: "\f140";
			font: 400 20px/1 dashicons;
			speak: none;
			display: block;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			text-decoration: none !important
		}

		.widget-top .widget-action .toggle-indicator:before {
			padding: 1px 2px 1px 0;
			border-radius: 50%
		}

		.accordion-section-title:after, .handlediv, .item-edit, .postbox .handlediv.button-link, .toggle-indicator {
			color: #72777c
		}

		.widget-action {
			color: #555d66
		}

		.accordion-section-title:hover:after, .handlediv:focus, .handlediv:hover, .item-edit:focus, .item-edit:hover, .postbox .handlediv.button-link:focus, .postbox .handlediv.button-link:hover, .sidebar-name:hover .toggle-indicator, .widget-action:focus, .widget-top:hover .widget-action {
			color: #23282d
		}

		.widget-top .widget-action:focus .toggle-indicator:before {
			box-shadow: 0 0 0 1px #5b9dd9, 0 0 2px 1px rgba(30, 140, 190, .8)
		}

		.accordion-section-title:after, .control-section .accordion-section-title:after {
			float: right;
			right: 20px;
			top: -2px
		}

		#customize-info.open .accordion-section-title:after, .control-section.open .accordion-section-title:after, .nav-menus-php .menu-item-edit-active .item-edit:before, .widget.open .widget-top .widget-action .toggle-indicator:before {
			content: "\f142"
		}

		/*!
	/* Chosen v1.2.0 | (c) 2011-2014 by Harvest | MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md */
		#geot_editor .chosen-container,
		#geot_widget .chosen-container,
		.geot_table .chosen-container,
		#geot-settings .chosen-container,
		.geot-settings .chosen-container {
			position: relative;
			display: inline-block;
			vertical-align: middle;
			font-size: 13px;
			zoom: 1;
			*display: inline;
			-webkit-user-select: none;
			-moz-user-select: none;
			user-select: none;
		}

		#geot_editor .chosen-container *,
		#geot_widget .chosen-container *,
		.geot_table .chosen-container *,
		#geot-settings .chosen-container *,
		.geot-settings .chosen-container * {
			-webkit-box-sizing: border-box;
			-moz-box-sizing: border-box;
			box-sizing: border-box;
		}

		#geot_editor .chosen-container .chosen-drop,
		#geot_widget .chosen-container .chosen-drop,
		.geot_table .chosen-container .chosen-drop,
		#geot-settings .chosen-container .chosen-drop,
		.geot-settings .chosen-container .chosen-drop {
			position: absolute;
			top: 100%;
			left: -9999px;
			z-index: 1010;
			width: 100%;
			border: 1px solid #aaa;
			border-top: 0;
			background: #fff;
			box-shadow: 0 4px 5px rgba(0, 0, 0, 0.15);
		}

		#geot_editor .chosen-container.chosen-with-drop .chosen-drop,
		#geot_widget .chosen-container.chosen-with-drop .chosen-drop,
		.geot_table .chosen-container.chosen-with-drop .chosen-drop,
		#geot-settings .chosen-container.chosen-with-drop .chosen-drop,
		.geot-settings .chosen-container.chosen-with-drop .chosen-drop {
			left: 0;
		}

		#geot_editor .chosen-container a,
		#geot_widget .chosen-container a,
		.geot_table .chosen-container a,
		#geot-settings .chosen-container a,
		.geot-settings .chosen-container a {
			cursor: pointer;
		}

		#geot_editor .chosen-container-single .chosen-single,
		#geot_widget .chosen-container-single .chosen-single,
		.geot_table .chosen-container-single .chosen-single,
		#geot-settings .chosen-container-single .chosen-single,
		.geot-settings .chosen-container-single .chosen-single {
			position: relative;
			display: block;
			overflow: hidden;
			padding: 0 0 0 8px;
			height: 25px;
			border: 1px solid #aaa;
			border-radius: 5px;
			background-color: #fff;
			background: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(20%, #fff), color-stop(50%, #f6f6f6), color-stop(52%, #eee), color-stop(100%, #f4f4f4));
			background: -webkit-linear-gradient(top, #fff 20%, #f6f6f6 50%, #eee 52%, #f4f4f4 100%);
			background: -moz-linear-gradient(top, #fff 20%, #f6f6f6 50%, #eee 52%, #f4f4f4 100%);
			background: -o-linear-gradient(top, #fff 20%, #f6f6f6 50%, #eee 52%, #f4f4f4 100%);
			background: linear-gradient(top, #fff 20%, #f6f6f6 50%, #eee 52%, #f4f4f4 100%);
			background-clip: padding-box;
			box-shadow: 0 0 3px #fff inset, 0 1px 1px rgba(0, 0, 0, 0.1);
			color: #444;
			text-decoration: none;
			white-space: nowrap;
			line-height: 24px;
		}

		#geot_editor .chosen-container-single .chosen-default,
		#geot_widget .chosen-container-single .chosen-default,
		.geot_table .chosen-container-single .chosen-default,
		#geot-settings .chosen-container-single .chosen-default,
		.geot-settings .chosen-container-single .chosen-default {
			color: #999;
		}

		#geot_editor .chosen-container-single .chosen-single span,
		#geot_widget .chosen-container-single .chosen-single span,
		.geot_table .chosen-container-single .chosen-single span,
		#geot-settings .chosen-container-single .chosen-single span,
		.geot-settings .chosen-container-single .chosen-single span {
			display: block;
			overflow: hidden;
			margin-right: 26px;
			text-overflow: ellipsis;
			white-space: nowrap;
		}

		#geot_editor .chosen-container-single .chosen-single-with-deselect span,
		#geot_widget .chosen-container-single .chosen-single-with-deselect span,
		.geot_table .chosen-container-single .chosen-single-with-deselect span,
		#geot-settings .chosen-container-single .chosen-single-with-deselect span,
		.geot-settings .chosen-container-single .chosen-single-with-deselect span {
			margin-right: 38px;
		}

		#geot_editor .chosen-container-single .chosen-single abbr,
		#geot_widget .chosen-container-single .chosen-single abbr,
		.geot_table .chosen-container-single .chosen-single abbr,
		#geot-settings .chosen-container-single .chosen-single abbr,
		.geot-settings .chosen-container-single .chosen-single abbr {
			position: absolute;
			top: 6px;
			right: 26px;
			display: block;
			width: 12px;
			height: 12px;
			background: url(../img/chosen-sprite.png) -42px 1px no-repeat;
			font-size: 1px;
		}

		#geot_editor .chosen-container-single .chosen-single abbr:hover,
		#geot_widget .chosen-container-single .chosen-single abbr:hover,
		.geot_table .chosen-container-single .chosen-single abbr:hover,
		#geot-settings .chosen-container-single .chosen-single abbr:hover,
		.geot-settings .chosen-container-single .chosen-single abbr:hover {
			background-position: -42px -10px;
		}

		#geot_editor .chosen-container-single.chosen-disabled .chosen-single abbr:hover,
		#geot_widget .chosen-container-single.chosen-disabled .chosen-single abbr:hover,
		.geot_table .chosen-container-single.chosen-disabled .chosen-single abbr:hover,
		#geot-settings .chosen-container-single.chosen-disabled .chosen-single abbr:hover,
		.geot-settings .chosen-container-single.chosen-disabled .chosen-single abbr:hover {
			background-position: -42px -10px;
		}

		#geot_editor .chosen-container-single .chosen-single div,
		#geot_widget .chosen-container-single .chosen-single div,
		.geot_table .chosen-container-single .chosen-single div,
		#geot-settings .chosen-container-single .chosen-single div,
		.geot-settings .chosen-container-single .chosen-single div {
			position: absolute;
			top: 0;
			right: 0;
			display: block;
			width: 18px;
			height: 100%;
		}

		#geot_editor .chosen-container-single .chosen-single div b,
		#geot_widget .chosen-container-single .chosen-single div b,
		.geot_table .chosen-container-single .chosen-single div b,
		#geot-settings .chosen-container-single .chosen-single div b,
		.geot-settings .chosen-container-single .chosen-single div b {
			display: block;
			width: 100%;
			height: 100%;
			background: url(../img/chosen-sprite.png) no-repeat 0 2px;
		}

		#geot_editor .chosen-container-single .chosen-search,
		#geot_widget .chosen-container-single .chosen-search,
		.geot_table .chosen-container-single .chosen-search,
		#geot-settings .chosen-container-single .chosen-search,
		.geot-settings .chosen-container-single .chosen-search {
			position: relative;
			z-index: 1010;
			margin: 0;
			padding: 3px 4px;
			white-space: nowrap;
		}

		#geot_editor .chosen-container-single .chosen-search input[type=text],
		#geot_widget .chosen-container-single .chosen-search input[type=text],
		.geot_table .chosen-container-single .chosen-search input[type=text],
		#geot-settings .chosen-container-single .chosen-search input[type=text],
		.geot-settings .chosen-container-single .chosen-search input[type=text] {
			margin: 1px 0;
			padding: 4px 20px 4px 5px;
			width: 100%;
			height: auto;
			outline: 0;
			border: 1px solid #aaa;
			background: #fff url(../img/chosen-sprite.png) no-repeat 100% -20px;
			background: url(../img/chosen-sprite.png) no-repeat 100% -20px;
			font-size: 1em;
			font-family: sans-serif;
			line-height: normal;
			border-radius: 0;
		}

		#geot_editor .chosen-container-single .chosen-drop,
		#geot_widget .chosen-container-single .chosen-drop,
		.geot_table .chosen-container-single .chosen-drop,
		#geot-settings .chosen-container-single .chosen-drop,
		.geot-settings .chosen-container-single .chosen-drop {
			margin-top: -1px;
			border-radius: 0 0 4px 4px;
			background-clip: padding-box;
		}

		#geot_editor .chosen-container-single.chosen-container-single-nosearch .chosen-search,
		#geot_widget .chosen-container-single.chosen-container-single-nosearch .chosen-search,
		.geot_table .chosen-container-single.chosen-container-single-nosearch .chosen-search,
		#geot-settings .chosen-container-single.chosen-container-single-nosearch .chosen-search,
		.geot-settings .chosen-container-single.chosen-container-single-nosearch .chosen-search {
			position: absolute;
			left: -9999px;
		}

		#geot_editor .chosen-container .chosen-results,
		#geot_widget .chosen-container .chosen-results,
		.geot_table .chosen-container .chosen-results,
		#geot-settings .chosen-container .chosen-results,
		.geot-settings .chosen-container .chosen-results {
			color: #444;
			position: relative;
			overflow-x: hidden;
			overflow-y: auto;
			margin: 0 4px 4px 0;
			padding: 0 0 0 4px;
			max-height: 240px;
			-webkit-overflow-scrolling: touch;
		}

		#geot_editor .chosen-container .chosen-results li,
		#geot_widget .chosen-container .chosen-results li,
		.geot_table .chosen-container .chosen-results li,
		#geot-settings .chosen-container .chosen-results li,
		.geot-settings .chosen-container .chosen-results li {
			display: none;
			margin: 0;
			padding: 5px 6px;
			list-style: none;
			line-height: 15px;
			word-wrap: break-word;
			-webkit-touch-callout: none;
		}

		#geot_editor .chosen-container .chosen-results li.active-result,
		#geot_widget .chosen-container .chosen-results li.active-result,
		.geot_table .chosen-container .chosen-results li.active-result,
		#geot-settings .chosen-container .chosen-results li.active-result,
		.geot-settings .chosen-container .chosen-results li.active-result {
			display: list-item;
			cursor: pointer;
		}

		#geot_editor .chosen-container .chosen-results li.disabled-result,
		#geot_widget .chosen-container .chosen-results li.disabled-result,
		.geot_table .chosen-container .chosen-results li.disabled-result,
		#geot-settings .chosen-container .chosen-results li.disabled-result,
		.geot-settings .chosen-container .chosen-results li.disabled-result {
			display: list-item;
			color: #ccc;
			cursor: default;
		}

		#geot_editor .chosen-container .chosen-results li.highlighted,
		#geot_widget .chosen-container .chosen-results li.highlighted,
		.geot_table .chosen-container .chosen-results li.highlighted,
		#geot-settings .chosen-container .chosen-results li.highlighted,
		.geot-settings .chosen-container .chosen-results li.highlighted {
			background-color: #3875d7;
			background-image: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(20%, #3875d7), color-stop(90%, #2a62bc));
			background-image: -webkit-linear-gradient(#3875d7 20%, #2a62bc 90%);
			background-image: -moz-linear-gradient(#3875d7 20%, #2a62bc 90%);
			background-image: -o-linear-gradient(#3875d7 20%, #2a62bc 90%);
			background-image: linear-gradient(#3875d7 20%, #2a62bc 90%);
			color: #fff;
		}

		#geot_editor .chosen-container .chosen-results li.no-results,
		#geot_widget .chosen-container .chosen-results li.no-results,
		.geot_table .chosen-container .chosen-results li.no-results,
		#geot-settings .chosen-container .chosen-results li.no-results,
		.geot-settings .chosen-container .chosen-results li.no-results {
			color: #777;
			display: list-item;
			background: #f4f4f4;
		}

		#geot_editor .chosen-container .chosen-results li.group-result,
		#geot_widget .chosen-container .chosen-results li.group-result,
		.geot_table .chosen-container .chosen-results li.group-result,
		#geot-settings .chosen-container .chosen-results li.group-result,
		.geot-settings .chosen-container .chosen-results li.group-result {
			display: list-item;
			font-weight: 700;
			cursor: default;
		}

		#geot_editor .chosen-container .chosen-results li.group-option,
		#geot_widget .chosen-container .chosen-results li.group-option,
		.geot_table .chosen-container .chosen-results li.group-option,
		#geot-settings .chosen-container .chosen-results li.group-option,
		.geot-settings .chosen-container .chosen-results li.group-option {
			padding-left: 15px;
		}

		#geot_editor .chosen-container .chosen-results li em,
		#geot_widget .chosen-container .chosen-results li em,
		.geot_table .chosen-container .chosen-results li em,
		#geot-settings .chosen-container .chosen-results li em,
		.geot-settings .chosen-container .chosen-results li em {
			font-style: normal;
			text-decoration: underline;
		}

		#geot_editor .chosen-container-multi .chosen-choices,
		#geot_widget .chosen-container-multi .chosen-choices,
		.geot_table .chosen-container-multi .chosen-choices,
		#geot-settings .chosen-container-multi .chosen-choices,
		.geot-settings .chosen-container-multi .chosen-choices {
			position: relative;
			overflow: hidden;
			margin: 0;
			padding: 0 5px;
			width: 100%;
			height: auto !important;
			height: 1%;
			border: 1px solid #aaa;
			background-color: #fff;
			background-image: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(1%, #eee), color-stop(15%, #fff));
			background-image: -webkit-linear-gradient(#eee 1%, #fff 15%);
			background-image: -moz-linear-gradient(#eee 1%, #fff 15%);
			background-image: -o-linear-gradient(#eee 1%, #fff 15%);
			background-image: linear-gradient(#eee 1%, #fff 15%);
			cursor: text;
		}

		#geot_editor .chosen-container-multi .chosen-choices li,
		#geot_widget .chosen-container-multi .chosen-choices li,
		.geot_table .chosen-container-multi .chosen-choices li,
		#geot-settings .chosen-container-multi .chosen-choices li,
		.geot-settings .chosen-container-multi .chosen-choices li {
			float: left;
			list-style: none;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-field,
		#geot_widget .chosen-container-multi .chosen-choices li.search-field,
		.geot_table .chosen-container-multi .chosen-choices li.search-field,
		#geot-settings .chosen-container-multi .chosen-choices li.search-field,
		.geot-settings .chosen-container-multi .chosen-choices li.search-field {
			margin: 0;
			padding: 0;
			white-space: nowrap;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-field input[type=text],
		#geot_widget .chosen-container-multi .chosen-choices li.search-field input[type=text],
		.geot_table .chosen-container-multi .chosen-choices li.search-field input[type=text],
		#geot-settings .chosen-container-multi .chosen-choices li.search-field input[type=text],
		.geot-settings .chosen-container-multi .chosen-choices li.search-field input[type=text] {
			margin: 1px 0;
			padding: 0;
			height: 25px;
			outline: 0;
			border: 0 !important;
			background: transparent !important;
			box-shadow: none;
			color: #999;
			font-size: 100%;
			font-family: sans-serif;
			line-height: normal;
			border-radius: 0;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice {
			position: relative;
			margin: 3px 5px 3px 0;
			padding: 3px 20px 3px 5px;
			border: 1px solid #aaa;
			max-width: 100%;
			border-radius: 3px;
			background-color: #eee;
			background-image: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), color-stop(100%, #eee));
			background-image: -webkit-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: -moz-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: -o-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-size: 100% 19px;
			background-repeat: repeat-x;
			background-clip: padding-box;
			box-shadow: 0 0 2px #fff inset, 0 1px 0 rgba(0, 0, 0, 0.05);
			color: #333;
			line-height: 13px;
			cursor: default;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice span,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice span,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice span,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice span,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice span {
			word-wrap: break-word;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice .search-choice-close,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice .search-choice-close,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice .search-choice-close,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice .search-choice-close,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice .search-choice-close {
			position: absolute;
			top: 4px;
			right: 3px;
			display: block;
			width: 12px;
			height: 12px;
			background: url(../img/chosen-sprite.png) -42px 1px no-repeat;
			font-size: 1px;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover {
			background-position: -42px -10px;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice-disabled,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice-disabled,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice-disabled,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice-disabled,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice-disabled {
			padding-right: 5px;
			border: 1px solid #ccc;
			background-color: #e4e4e4;
			background-image: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), color-stop(100%, #eee));
			background-image: -webkit-linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: -moz-linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: -o-linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			background-image: linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);
			color: #666;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice-focus,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice-focus,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice-focus,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice-focus,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice-focus {
			background: #d4d4d4;
		}

		#geot_editor .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close,
		#geot_widget .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close,
		.geot_table .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close,
		#geot-settings .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close,
		.geot-settings .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close {
			background-position: -42px -10px;
		}

		#geot_editor .chosen-container-multi .chosen-results,
		#geot_widget .chosen-container-multi .chosen-results,
		.geot_table .chosen-container-multi .chosen-results,
		#geot-settings .chosen-container-multi .chosen-results,
		.geot-settings .chosen-container-multi .chosen-results {
			margin: 0;
			padding: 0;
		}

		#geot_editor .chosen-container-multi .chosen-drop .result-selected,
		#geot_widget .chosen-container-multi .chosen-drop .result-selected,
		.geot_table .chosen-container-multi .chosen-drop .result-selected,
		#geot-settings .chosen-container-multi .chosen-drop .result-selected,
		.geot-settings .chosen-container-multi .chosen-drop .result-selected {
			display: list-item;
			color: #ccc;
			cursor: default;
		}

		#geot_editor .chosen-container-active .chosen-single,
		#geot_widget .chosen-container-active .chosen-single,
		.geot_table .chosen-container-active .chosen-single,
		#geot-settings .chosen-container-active .chosen-single,
		.geot-settings .chosen-container-active .chosen-single {
			border: 1px solid #5897fb;
			box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);
		}

		#geot_editor .chosen-container-active.chosen-with-drop .chosen-single,
		#geot_widget .chosen-container-active.chosen-with-drop .chosen-single,
		.geot_table .chosen-container-active.chosen-with-drop .chosen-single,
		#geot-settings .chosen-container-active.chosen-with-drop .chosen-single,
		.geot-settings .chosen-container-active.chosen-with-drop .chosen-single {
			border: 1px solid #aaa;
			-moz-border-radius-bottomright: 0;
			border-bottom-right-radius: 0;
			-moz-border-radius-bottomleft: 0;
			border-bottom-left-radius: 0;
			background-image: -webkit-gradient(linear, 50% 0, 50% 100%, color-stop(20%, #eee), color-stop(80%, #fff));
			background-image: -webkit-linear-gradient(#eee 20%, #fff 80%);
			background-image: -moz-linear-gradient(#eee 20%, #fff 80%);
			background-image: -o-linear-gradient(#eee 20%, #fff 80%);
			background-image: linear-gradient(#eee 20%, #fff 80%);
			box-shadow: 0 1px 0 #fff inset;
		}

		#geot_editor .chosen-container-active.chosen-with-drop .chosen-single div,
		#geot_widget .chosen-container-active.chosen-with-drop .chosen-single div,
		.geot_table .chosen-container-active.chosen-with-drop .chosen-single div,
		#geot-settings .chosen-container-active.chosen-with-drop .chosen-single div,
		.geot-settings .chosen-container-active.chosen-with-drop .chosen-single div {
			border-left: 0;
			background: transparent;
		}

		#geot_editor .chosen-container-active.chosen-with-drop .chosen-single div b,
		#geot_widget .chosen-container-active.chosen-with-drop .chosen-single div b,
		.geot_table .chosen-container-active.chosen-with-drop .chosen-single div b,
		#geot-settings .chosen-container-active.chosen-with-drop .chosen-single div b,
		.geot-settings .chosen-container-active.chosen-with-drop .chosen-single div b {
			background-position: -18px 2px;
		}

		#geot_editor .chosen-container-active .chosen-choices,
		#geot_widget .chosen-container-active .chosen-choices,
		.geot_table .chosen-container-active .chosen-choices,
		#geot-settings .chosen-container-active .chosen-choices,
		.geot-settings .chosen-container-active .chosen-choices {
			border: 1px solid #5897fb;
			box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);
		}

		#geot_editor .chosen-container-active .chosen-choices li.search-field input[type=text],
		#geot_widget .chosen-container-active .chosen-choices li.search-field input[type=text],
		.geot_table .chosen-container-active .chosen-choices li.search-field input[type=text],
		#geot-settings .chosen-container-active .chosen-choices li.search-field input[type=text],
		.geot-settings .chosen-container-active .chosen-choices li.search-field input[type=text] {
			color: #222 !important;
		}

		#geot_editor .chosen-disabled,
		#geot_widget .chosen-disabled,
		.geot_table .chosen-disabled,
		#geot-settings .chosen-disabled,
		.geot-settings .chosen-disabled {
			opacity: 0.5 !important;
			cursor: default;
		}

		#geot_editor .chosen-disabled .chosen-single,
		#geot_widget .chosen-disabled .chosen-single,
		.geot_table .chosen-disabled .chosen-single,
		#geot-settings .chosen-disabled .chosen-single,
		.geot-settings .chosen-disabled .chosen-single {
			cursor: default;
		}

		#geot_editor .chosen-disabled .chosen-choices .search-choice .search-choice-close,
		#geot_widget .chosen-disabled .chosen-choices .search-choice .search-choice-close,
		.geot_table .chosen-disabled .chosen-choices .search-choice .search-choice-close,
		#geot-settings .chosen-disabled .chosen-choices .search-choice .search-choice-close,
		.geot-settings .chosen-disabled .chosen-choices .search-choice .search-choice-close {
			cursor: default;
		}

		#geot_editor .chosen-rtl,
		#geot_widget .chosen-rtl,
		.geot_table .chosen-rtl,
		#geot-settings .chosen-rtl,
		.geot-settings .chosen-rtl {
			text-align: right;
		}

		#geot_editor .chosen-rtl .chosen-single,
		#geot_widget .chosen-rtl .chosen-single,
		.geot_table .chosen-rtl .chosen-single,
		#geot-settings .chosen-rtl .chosen-single,
		.geot-settings .chosen-rtl .chosen-single {
			overflow: visible;
			padding: 0 8px 0 0;
		}

		#geot_editor .chosen-rtl .chosen-single span,
		#geot_widget .chosen-rtl .chosen-single span,
		.geot_table .chosen-rtl .chosen-single span,
		#geot-settings .chosen-rtl .chosen-single span,
		.geot-settings .chosen-rtl .chosen-single span {
			margin-right: 0;
			margin-left: 26px;
			direction: rtl;
		}

		#geot_editor .chosen-rtl .chosen-single-with-deselect span,
		#geot_widget .chosen-rtl .chosen-single-with-deselect span,
		.geot_table .chosen-rtl .chosen-single-with-deselect span,
		#geot-settings .chosen-rtl .chosen-single-with-deselect span,
		.geot-settings .chosen-rtl .chosen-single-with-deselect span {
			margin-left: 38px;
		}

		#geot_editor .chosen-rtl .chosen-single div,
		#geot_widget .chosen-rtl .chosen-single div,
		.geot_table .chosen-rtl .chosen-single div,
		#geot-settings .chosen-rtl .chosen-single div,
		.geot-settings .chosen-rtl .chosen-single div {
			right: auto;
			left: 3px;
		}

		#geot_editor .chosen-rtl .chosen-single abbr,
		#geot_widget .chosen-rtl .chosen-single abbr,
		.geot_table .chosen-rtl .chosen-single abbr,
		#geot-settings .chosen-rtl .chosen-single abbr,
		.geot-settings .chosen-rtl .chosen-single abbr {
			right: auto;
			left: 26px;
		}

		#geot_editor .chosen-rtl .chosen-choices li,
		#geot_widget .chosen-rtl .chosen-choices li,
		.geot_table .chosen-rtl .chosen-choices li,
		#geot-settings .chosen-rtl .chosen-choices li,
		.geot-settings .chosen-rtl .chosen-choices li {
			float: right;
		}

		#geot_editor .chosen-rtl .chosen-choices li.search-field input[type=text],
		#geot_widget .chosen-rtl .chosen-choices li.search-field input[type=text],
		.geot_table .chosen-rtl .chosen-choices li.search-field input[type=text],
		#geot-settings .chosen-rtl .chosen-choices li.search-field input[type=text],
		.geot-settings .chosen-rtl .chosen-choices li.search-field input[type=text] {
			direction: rtl;
		}

		#geot_editor .chosen-rtl .chosen-choices li.search-choice,
		#geot_widget .chosen-rtl .chosen-choices li.search-choice,
		.geot_table .chosen-rtl .chosen-choices li.search-choice,
		#geot-settings .chosen-rtl .chosen-choices li.search-choice,
		.geot-settings .chosen-rtl .chosen-choices li.search-choice {
			margin: 3px 5px 3px 0;
			padding: 3px 5px 3px 19px;
		}

		#geot_editor .chosen-rtl .chosen-choices li.search-choice .search-choice-close,
		#geot_widget .chosen-rtl .chosen-choices li.search-choice .search-choice-close,
		.geot_table .chosen-rtl .chosen-choices li.search-choice .search-choice-close,
		#geot-settings .chosen-rtl .chosen-choices li.search-choice .search-choice-close,
		.geot-settings .chosen-rtl .chosen-choices li.search-choice .search-choice-close {
			right: auto;
			left: 4px;
		}

		#geot_editor .chosen-rtl.chosen-container-single-nosearch .chosen-search, #geot_editor .chosen-rtl .chosen-drop,
		#geot_widget .chosen-rtl.chosen-container-single-nosearch .chosen-search,
		#geot_widget .chosen-rtl .chosen-drop,
		.geot_table .chosen-rtl.chosen-container-single-nosearch .chosen-search,
		.geot_table .chosen-rtl .chosen-drop,
		#geot-settings .chosen-rtl.chosen-container-single-nosearch .chosen-search,
		#geot-settings .chosen-rtl .chosen-drop,
		.geot-settings .chosen-rtl.chosen-container-single-nosearch .chosen-search,
		.geot-settings .chosen-rtl .chosen-drop {
			left: 9999px;
		}

		#geot_editor .chosen-rtl.chosen-container-single .chosen-results,
		#geot_widget .chosen-rtl.chosen-container-single .chosen-results,
		.geot_table .chosen-rtl.chosen-container-single .chosen-results,
		#geot-settings .chosen-rtl.chosen-container-single .chosen-results,
		.geot-settings .chosen-rtl.chosen-container-single .chosen-results {
			margin: 0 0 4px 4px;
			padding: 0 4px 0 0;
		}

		#geot_editor .chosen-rtl .chosen-results li.group-option,
		#geot_widget .chosen-rtl .chosen-results li.group-option,
		.geot_table .chosen-rtl .chosen-results li.group-option,
		#geot-settings .chosen-rtl .chosen-results li.group-option,
		.geot-settings .chosen-rtl .chosen-results li.group-option {
			padding-right: 15px;
			padding-left: 0;
		}

		#geot_editor .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div,
		#geot_widget .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div,
		.geot_table .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div,
		#geot-settings .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div,
		.geot-settings .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div {
			border-right: 0;
		}

		#geot_editor .chosen-rtl .chosen-search input[type=text],
		#geot_widget .chosen-rtl .chosen-search input[type=text],
		.geot_table .chosen-rtl .chosen-search input[type=text],
		#geot-settings .chosen-rtl .chosen-search input[type=text],
		.geot-settings .chosen-rtl .chosen-search input[type=text] {
			padding: 4px 5px 4px 20px;
			background: #fff url(../img/chosen-sprite.png) no-repeat -30px -20px;
			background: url(../img/chosen-sprite.png) no-repeat -30px -20px;
			direction: rtl;
		}

		#geot_editor .chosen-rtl.chosen-container-single .chosen-single div b,
		#geot_widget .chosen-rtl.chosen-container-single .chosen-single div b,
		.geot_table .chosen-rtl.chosen-container-single .chosen-single div b,
		#geot-settings .chosen-rtl.chosen-container-single .chosen-single div b,
		.geot-settings .chosen-rtl.chosen-container-single .chosen-single div b {
			background-position: 6px 2px;
		}

		#geot_editor .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b,
		#geot_widget .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b,
		.geot_table .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b,
		#geot-settings .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b,
		.geot-settings .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b {
			background-position: -12px 2px;
		}

		@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-resolution: 144dpi) {
			#geot_editor .chosen-rtl .chosen-search input[type=text], #geot_editor .chosen-container-single .chosen-single abbr, #geot_editor .chosen-container-single .chosen-single div b, #geot_editor .chosen-container-single .chosen-search input[type=text], #geot_editor .chosen-container-multi .chosen-choices .search-choice .search-choice-close, #geot_editor .chosen-container .chosen-results-scroll-down span, #geot_editor .chosen-container .chosen-results-scroll-up span,
			#geot_widget .chosen-rtl .chosen-search input[type=text],
			#geot_widget .chosen-container-single .chosen-single abbr,
			#geot_widget .chosen-container-single .chosen-single div b,
			#geot_widget .chosen-container-single .chosen-search input[type=text],
			#geot_widget .chosen-container-multi .chosen-choices .search-choice .search-choice-close,
			#geot_widget .chosen-container .chosen-results-scroll-down span,
			#geot_widget .chosen-container .chosen-results-scroll-up span,
			.geot_table .chosen-rtl .chosen-search input[type=text],
			.geot_table .chosen-container-single .chosen-single abbr,
			.geot_table .chosen-container-single .chosen-single div b,
			.geot_table .chosen-container-single .chosen-search input[type=text],
			.geot_table .chosen-container-multi .chosen-choices .search-choice .search-choice-close,
			.geot_table .chosen-container .chosen-results-scroll-down span,
			.geot_table .chosen-container .chosen-results-scroll-up span,
			#geot-settings .chosen-rtl .chosen-search input[type=text],
			#geot-settings .chosen-container-single .chosen-single abbr,
			#geot-settings .chosen-container-single .chosen-single div b,
			#geot-settings .chosen-container-single .chosen-search input[type=text],
			#geot-settings .chosen-container-multi .chosen-choices .search-choice .search-choice-close,
			#geot-settings .chosen-container .chosen-results-scroll-down span,
			#geot-settings .chosen-container .chosen-results-scroll-up span,
			.geot-settings .chosen-rtl .chosen-search input[type=text],
			.geot-settings .chosen-container-single .chosen-single abbr,
			.geot-settings .chosen-container-single .chosen-single div b,
			.geot-settings .chosen-container-single .chosen-search input[type=text],
			.geot-settings .chosen-container-multi .chosen-choices .search-choice .search-choice-close,
			.geot-settings .chosen-container .chosen-results-scroll-down span,
			.geot-settings .chosen-container .chosen-results-scroll-up span {
				background-image: url(../img/chosen-sprite@2x.png) !important;
				background-size: 52px 37px !important;
				background-repeat: no-repeat !important;
			}
		}

		.form-table {
			width: 90%;
			margin: 30px auto;
		}

		.form-table th {
			text-align: left;
		}

		.form-table td {
			padding-bottom: 15px;
		}

		input[type="text"] {
			width: 98%;
			height: 22px;
		}

		.button-primary {
			background: #0085ba;
			border-color: #0073aa #006799 #006799;
			box-shadow: 0 1px 0 #006799;
			color: #fff;
			text-decoration: none;
			text-shadow: 0 -1px 1px #006799, 1px 0 1px #006799, 0 1px 1px #006799, -1px 0 1px #006799;
			height: 30px;
			line-height: 28px;
			padding: 0 12px 2px;
			text-align: center;
			margin: 0 auto;
			display: block;
		}
	</style>
</head>
<body
		onload="document.body.style.display='';"
		dir="ltr">
<div class="modal geot-wrapper">
	<?php require_once( dirname( __FILE__ ) . '/tinymce-editor.php' ); ?>
	<button class="button-primary geot-insert">Add Shortcode</button>
</div>

<script type="text/javascript">
    var args = top.tinymce.activeEditor.windowManager.getParams();
    var parentEditor = args['editor'];
    var jQuery = args['jquery'];
</script>
<script type="text/javascript"
        src="<?php echo plugin_dir_url( GEOTROOT_PLUGIN_FILE ) . 'includes/geot/Setting/js/selectize.min.js'; ?>"></script>

<script type="text/javascript">

    (function ($) {
        $.ready(function () {
            $.find(".geot-chosen-select-multiple").selectize({plugins: ['remove_button'],});
        });
        $.find('.geot-insert').on('click', function () {

            var mode = $.find('#geot_editor .geot_include_mode:checked').val();

            if ($.find('#geot_zip').val() != '') {
                var str = '[geot_filter_zip ';
                if (mode == 'include') {
                    str += 'zip="';
                } else {
                    str += 'exclude_zip="';
                }

                str += $.find('#geot_zip').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_zip]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_zip]";

                }
            } else if ($.find('#geot_zip_region').val() != '') {
                var str = '[geot_filter_zip ';
                if (mode == 'include') {
                    str += 'region="';
                } else {
                    str += 'exclude_region="';
                }

                str += $.find('#geot_zip_region').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_zip]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_zip]";

                }

            } else if ($.find('#geot_state').val() != '') {
                var str = '[geot_filter_state ';
                if (mode == 'include') {
                    str += 'state="';
                } else {
                    str += 'exclude_state="';
                }

                str += $.find('#geot_state').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_state]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_state]";

                }
            } else if ($.find('#geot_state_region').val() != '') {
                var str = '[geot_filter_state ';
                if (mode == 'include') {
                    str += 'region="';
                } else {
                    str += 'exclude_region="';
                }

                str += $.find('#geot_state_region').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_state]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_state]";

                }

            } else if ($.find('#geot_city').val() != '') {
                var str = '[geot_filter_city ';
                if (mode == 'include') {
                    str += 'city="';
                } else {
                    str += 'exclude_city="';
                }

                str += $.find('#geot_city').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_city]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_city]";

                }
            } else if ($.find('#geot_city_region').val() != '') {
                var str = '[geot_filter_city ';
                if (mode == 'include') {
                    str += 'region="';
                } else {
                    str += 'exclude_region="';
                }

                str += $.find('#geot_city_region').val();

                str += '" ';

                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter_city]";

                } else {

                    str += "]<p>Please add your content in this area.</p>[/geot_filter_city]";

                }
            } else {

                var str = '[geot_filter ';

                if ($.find('#geot_region').val()) {
                    if (mode == 'include') {
                        str += 'region="';
                    } else {
                        str += 'exclude_region="';
                    }

                    str += $.find('#geot_region').val();

                    str += '" ';
                }

                if ($.find('#geot_country').val()) {
                    if (mode == 'include') {
                        str += 'country="';
                    } else {
                        str += 'exclude_country="';
                    }

                    str += $.find('#geot_country').val();

                    str += '" ';
                }


                var selected_text = parentEditor.selection.getContent();
                if (selected_text) {

                    str += "]" + selected_text + "[/geot_filter]";

                } else {

                    str += "] <p>Please add your content in this area.</p> [/geot_filter]";

                }

            }

            parentEditor.execCommand('mceInsertContent', false, str);

            parentEditor.windowManager.close();
        })
    })(jQuery(document));


</script>
</body>
</html>
