/**
 * 
 * This file is implemented
 * From Tilopay plugin V 2.0.0
 * more info tilopay.com
 * 
 */

jQuery(document).ready(function ($) {
  let searchParams = new URLSearchParams(window.location.search);
  let payment_order = "";
  let payment_method_selected = "";
  if (
    searchParams.has("process_payment") &&
    searchParams.has("payment_order") &&
    searchParams.has("method")
  ) {
    $.LoadingOverlay("show", {
      maxSize: 70,
      imageColor: "#626262",
    });
    payment_order = searchParams.get("payment_order");
    let method = atob(searchParams.get("method")).split("|");
    payment_method_selected = method[0];
    if (method[1] == "1") {
      $("#terms").prop("checked", true);
    }
    tilopayConfig.orderNumber = payment_order;
    tilopayConfig.redirect = tilopayConfig.redirect + '?selected_method=SINPEMOVIL';//add flag to validate
    tilopayConfig.payment_method_selected = payment_method_selected;
  }
  //check if woo is set
  if (typeof wc_checkout_params === "undefined") return false;

  //check if checkout page wc_checkout_params.is_checkout

  //change one of this input attemp place order to get order number
  jQuery(document).on("change", "#ccnumber, #expdate, #cvv", function (e) {
    //let searchParams = new URLSearchParams(window.location.search);
    let ccnumber = $("#ccnumber").val();
    let expdate = $("#expdate").val();
    let cvv = $("#cvv").val();
    let selectCard = $("#cards").val();
    if ((ccnumber != "", expdate != "" && cvv != "")) {
      let res = Tilopay.getCipherData();
      ///al cambiar tarjeta no toma
      $("#token_hash_card_tilopay").val("");
      $("#token_hash_code_tilopay").val("");
      //if all is ok
      if (
        typeof res.card != "undefined" &&
        res.card != "" &&
        typeof res.cvv != "undefined" &&
        res.cvv != ""
      ) {
        $("#token_hash_card_tilopay").val(res.card);
        $("#token_hash_code_tilopay").val(res.cvv);
      } else {
        //erro
        $("#tpay-sdk-error-div").show();
        $("#error-sdk-li").fadeOut(1000, function () {
          $(this).remove();
        });
        $("#tpay-sdk-error").append(
          $("<li id='error-sdk-li'>").text(tilopayConfig.cardError)
        );
      }
    } else {
      $("#token_hash_card_tilopay").val("");
      $("#token_hash_code_tilopay").val("");
    }
    //call to validate input and get cipher
  });

  //set card icon
  jQuery(document).on("change keyup paste", "#ccnumber", function (e) {
    if (
      $(this).val() !== "" &&
      ($(this).val().length == 3 || $(this).val().length >= 15)
    ) {
      set_card_icon();
    }
  });

  let checkEmail = "";
  //on change billing_email
  $("form.checkout").on("change", "#billing_email", function () {
    checkEmail = $(this).val();
    if (checkEmail != "") {
      initSDKTilopay();
    }
  }); //.end on change billing_email

  //event handler
  //click close modal
  document.addEventListener("click", function (e) {
    const tgt = e.target;

    if (tgt.classList.contains("payWithSinpeMovil")) {
      //on open modal check
      document.querySelector(tgt.dataset.modal).classList.add("active");
    } else if (
      tgt.classList.contains("tilopay-overlay") ||
      tgt.classList.contains("btn-tilopay-close-modal")
    ) {
      //close modal on click out of modal or btn
      tgt.closest(".tilopay-modal-container").classList.remove("active");
    }
  });
}); //.end ready

function set_card_icon() {
  let typeCard =
    "https://plugin-wp-tilo.test/wp-content/plugins/tilopay//assets/images/tilopay_color.png";
  var type = Tilopay.getCardType();
  if (typeof type.message !== undefined) {
    $("#card_type_tilopay").val(type.message);
    switch (type.message) {
      case "visa":
        typeCard =
          "url(https://plugin-wp-tilo.test/wp-content/plugins/tilopay//assets/images/visa.svg)";
        break;
      case "mastercard":
        typeCard =
          "url(https://plugin-wp-tilo.test/wp-content/plugins/tilopay//assets/images/mastercard.svg)";
        break;
      case "amex":
        typeCard =
          "url(https://plugin-wp-tilo.test/wp-content/plugins/tilopay//assets/images/american_express.svg)";
        break;
      default:
        typeCard =
          "https://plugin-wp-tilo.test/wp-content/plugins/tilopay//assets/images/tilopay_color.png";
        break;
    }
  }
  $("#ccnumber").css("background-image", typeCard);
}

function onchange_select_card() {
  if ($("#cards").val() != "") {
    if ($("#cards").val() == "newCard" || $("#cards").val() == 0) {
      $("#divCardNumber").show();
      $("#divCardDate").show();
      $("#divCardCvc").show();
      $("#divCardCvc")
        .removeClass("form-row form-row-first")
        .addClass("form-row form-row-last");
      if ($("#tpay_env").val() == "PROD") {
        $("#divSaveCard").show();
      }
    } else {
      $("#divCardNumber").hide();
      $("#divCardDate").hide();
      $("#divCardCvc").show();
      $("#divCardCvc")
        .removeClass("form-row form-row-last")
        .addClass("form-row form-row-first");
      if ($("#tpay_env").val() == "PROD") {
        $("#divSaveCard").hide();
      }
    }
  }
}

function initSDKTilopay() {
  let payment_method_selected =
    typeof tilopayConfig.payment_method_selected != "undefined"
      ? tilopayConfig.payment_method_selected
      : "";

  let getInputEmail = $("#billing_email").val();
  //check if email at input are same that we pass from BE
  if (getInputEmail != "" && tilopayConfig.billToEmail != getInputEmail) {
    tilopayConfig.billToEmail = getInputEmail;
  }

  var initialize = Tilopay.Init(tilopayConfig);
  //if environment not set
  if (
    typeof initialize.environment != "undefined" &&
    initialize.environment != "PROD"
  ) {
    $("#tpay_env").val(initialize.environment);
    $("#environment").show();
    $("#environment").html(
      tilopayConfig.envMode +
        ' <a href="http://admin.tilopay.com/">Admin Tilopay</a>'
    );
    $("#environment").parent().addClass("woocommerce-error");
  }

  if (
    typeof initialize.message != "undefined" &&
    initialize.message == "Success"
  ) {
    let paymentMethods = initialize.methods.length;
    let onlyOneMethod = 0;
    if (paymentMethods > 0) {
      $("#method option:not(:first)").remove();
      //method
      initialize.methods.forEach(function (method, index) {
 
        $("#method").append(
          $("<option>", {
            value: method.id,
            text: method.name,
            selected: index == 0 ? true : false,
          })
        );
      });
      //get if sinpe the first
      onlyOneMethod = initialize.methods[0].id.split(":")[1];

      //select firstone if only one
      if (paymentMethods == 1 && payment_method_selected == "") {
        $("#method").val(initialize.methods[0].id);
        $("#method").hide();
        $("#methodLabel").hide();
        if (onlyOneMethod == "4") {
          $("#selectCard").hide();
          $("#pay_sinpemovil_tilopay").val(1);
          $("#divTpaySinpeMovil").show();
        }
      }
      if (payment_method_selected != "") {
        $("#pay_sinpemovil_tilopay").val(1);
        $("#selectCard").hide();
        $("#method").val(payment_method_selected);
        var sinpemovilMethod = Tilopay.getSinpeMovil();
        if (
          typeof sinpemovilMethod.message != "undefined" &&
          sinpemovilMethod.message == "Success" &&
          sinpemovilMethod.code != "" &&
          sinpemovilMethod.amount != "" &&
          sinpemovilMethod.number != ""
        ) {
          //init sinpeMovil
          $.LoadingOverlay("hide");
          $("#tilopay-m1").addClass("active");
          //check with SDK
          var res = Tilopay.sinpeMovil();

          $("#tilopay-sinpemovil-code").text(sinpemovilMethod.code);
          $("#tilopay-sinpemovil-amount").text(sinpemovilMethod.amount);
          $("#tilopay-sinpemovil-number").text(sinpemovilMethod.number);
        }
      }
    }

    //cards
    let countCard = initialize.cards.length;
    $("#cards option:not(:first)").remove();
    tilopayConfig.haveCard = countCard;
    //console.log(initialize.cards);
    if (countCard > 0) {
      if (payment_method_selected == "" && onlyOneMethod != "4") {
        $("#selectCard").show();
      }

      //hidde
      $("#divCardNumber").hide();
      $("#divCardDate").hide();
      $("#divCardCvc").hide();
      //each card
      initialize.cards.forEach(function (card, index) {
        $("#cards").append(
          $("<option>", {
            value: card.id.split(":")[0],
            text: card.name,
          })
        );
      });

      //append other card
      $("#cards").append(
        $("<option>", {
          value: "newCard",
          text: tilopayConfig.newCardText,
        })
      );
      $("#divSaveCard").hide();
    } else {
      $("#selectCard").hide();
      if ($("#tpay_env").val() == "PROD") {
        $("#divSaveCard").show();
      }
      //divCardNumber,divCardDate,divCardCvc
      //form-row form-row-first, form-row form-row-last
      $("#divCardNumber").show();
      $("#divCardDate").show();
      $("#divCardCvc").show();
    }
  } else {
    //erro
    $("#tpay-sdk-error-div").show();
    $("#error-sdk-li").fadeOut(1000, function () {
      $(this).remove();
    });
    $("#tpay-sdk-error").append(
      $("<li id='error-sdk-li'>").text(tilopayConfig.integrationError)
    );
  }
}

function onchange_payment_method(selectObject) {
  //get sinpemovil
  let valSelected = selectObject.value;
  let isSinpeMovil = valSelected.split(":")[1];
  if (isSinpeMovil == "4") {
    $("#selectCard").hide();
    $("#pay_sinpemovil_tilopay").val(1);
    $("#divTpaySinpeMovil").show();
    $("#divTpayCardForm").hide();
  } else {
    $("#pay_sinpemovil_tilopay").val(0);
    $("#divTpaySinpeMovil").hide();
    $("#divTpayCardForm").show();
    if (tilopayConfig.haveCard > 0) {
      $("#selectCard").show();
    }
  }
}

// function check_payment_sinpemovil(cancel) {
//   let sinpemovilCode = $("#tilopay-sinpemovil-code").text();
//   let sinpemovilPhone = $("#tilopay-sinpemovil-number").text();
//   if (typeof sinpemovilCode != "undefined" && sinpemovilCode != "") {
//     //each 10 second
//     let intervalPayment = setInterval(function () {
//       console.log("setInterval");
//       var request = $.ajax({
//         url: tilopayConfig.urlTilopay + "/admin/checkSinpe",
//         type: "POST",
//         data: {
//           key: tilopayConfig.Key,
//           code: sinpemovilCode,
//           reference: "",
//         },
//         dataType: "JSON",
//       });

//       request.done(function (response) {
//         console.log(response);
//         if (typeof response.isvalid != "undefined" && response.isvalid == 1) {
//           clearInterval(intervalPayment);
//           var res = Tilopay.sinpeMovil();
//           console.log(res);
//           //remove loading class
//           $("#process-tilopay").removeClass("loading");
//           $("#process-tilopay").removeAttr("disabled");
//         }
//       });

//       request.fail(function (jqXHR, textStatus) {
//         clearInterval(intervalPayment);
//         console.log("response error");
//         alert("Request failed: " + textStatus);
//         console.log(jqXHR);
//       });
//     }, 5000);
//     if (cancel) {
//       clearInterval(intervalPayment);
//     }
//   } else {
//     //show errors
//     console.log("error code");
//   }
// }
