<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

// Función de Search personalizado:

function redireccionar_busqueda() {
    if (isset($_GET['search'])) {
        $search_query = sanitize_text_field($_GET['search']);

        // Buscar por producto
        $args = array(
            'post_type' => 'product',
            's' => $search_query,
        );
        $productos = get_posts($args);

        // Redireccionar a la página de tienda con el término de búsqueda
        if ($productos) {
            wp_redirect(get_permalink(get_option('woocommerce_shop_page_id')) . '?s=' . $search_query);
            exit;
        }
    }
}
add_action('template_redirect', 'redireccionar_busqueda');

// ---------------------------------------------------------------------------- //
